/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class DiffFileCountFilter
extends CommitDiffFilter {
    private long added;
    private long edited;
    private long deleted;
    private long renamed;
    private long copied;

    public DiffFileCountFilter() {
    }

    public DiffFileCountFilter(boolean detectRenames) {
        super(detectRenames);
    }

    public long getAdded() {
        return this.added;
    }

    public long getEdited() {
        return this.edited;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getRenamed() {
        return this.renamed;
    }

    public long getCopied() {
        return this.copied;
    }

    public long getTotal() {
        return this.added + this.edited + this.deleted + this.renamed + this.copied;
    }

    @Override
    public boolean include(RevCommit commit, Collection<DiffEntry> diffs) {
        for (DiffEntry diff : diffs) {
            switch (diff.getChangeType()) {
                case ADD: {
                    ++this.added;
                    break;
                }
                case MODIFY: {
                    ++this.edited;
                    break;
                }
                case DELETE: {
                    ++this.deleted;
                    break;
                }
                case RENAME: {
                    ++this.renamed;
                    break;
                }
                case COPY: {
                    ++this.copied;
                }
            }
        }
        return true;
    }

    @Override
    public CommitFilter reset() {
        this.added = 0L;
        this.edited = 0L;
        this.deleted = 0L;
        this.renamed = 0L;
        this.copied = 0L;
        return super.reset();
    }

    @Override
    public RevFilter clone() {
        return new DiffFileCountFilter(this.detectRenames);
    }
}

