/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitFilter;

public abstract class CompositeCommitFilter
extends CommitFilter {
    protected RevFilter[] filters;

    public CompositeCommitFilter(RevFilter ... filters) {
        if (filters != null && filters.length > 0) {
            this.filters = new RevFilter[filters.length];
            System.arraycopy(filters, 0, this.filters, 0, filters.length);
        } else {
            this.filters = new RevFilter[0];
        }
    }

    public CompositeCommitFilter add(RevFilter ... addedFilters) {
        if (addedFilters == null) {
            return this;
        }
        int added = addedFilters.length;
        if (added == 0) {
            return this;
        }
        int current = this.filters.length;
        RevFilter[] resized = new RevFilter[added + current];
        System.arraycopy(this.filters, 0, resized, 0, current);
        System.arraycopy(addedFilters, 0, resized, current, added);
        this.filters = resized;
        return this;
    }

    @Override
    public CommitFilter setRepository(Repository repository) {
        for (RevFilter filter : this.filters) {
            if (!(filter instanceof CommitFilter)) continue;
            ((CommitFilter)filter).setRepository(repository);
        }
        return super.setRepository(repository);
    }

    @Override
    public CommitFilter reset() {
        for (RevFilter filter : this.filters) {
            if (!(filter instanceof CommitFilter)) continue;
            ((CommitFilter)filter).reset();
        }
        return super.reset();
    }

    protected RevFilter[] cloneFilters() {
        RevFilter[] copy = new RevFilter[this.filters.length];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        return copy;
    }

    public int getSize() {
        return this.filters.length;
    }
}

