/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.servlet;

import io.fabric8.common.util.Strings;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;

public class ProxyDetails {
    private final boolean valid;
    private final String stringProxyURL;
    private String proxyHostAndPort;
    private String proxyPath;

    public ProxyDetails(boolean valid, String stringProxyURL) {
        this.valid = valid;
        this.stringProxyURL = stringProxyURL;
        if (this.proxyHostAndPort == null) {
            return;
        }
        while (this.proxyHostAndPort.startsWith("/")) {
            this.proxyHostAndPort = this.proxyHostAndPort.substring(1);
        }
        int port = 0;
        String host = this.proxyHostAndPort;
        int idx = this.indexOf(this.proxyHostAndPort, ":", "/");
        if (idx > 0) {
            host = this.proxyHostAndPort.substring(0, idx);
            String portText = this.proxyHostAndPort.substring(idx + 1);
            if ((idx = portText.indexOf("/")) >= 0) {
                this.proxyPath = portText.substring(idx);
                portText = portText.substring(0, idx);
            }
            if (Strings.isNotBlank((String)portText)) {
                try {
                    port = Integer.parseInt(portText);
                    this.proxyHostAndPort = host + ":" + port;
                }
                catch (NumberFormatException e) {
                    port = 80;
                    this.proxyPath = "/" + portText + this.proxyPath;
                    this.proxyHostAndPort = host;
                }
            } else {
                this.proxyHostAndPort = host;
            }
        }
    }

    protected int indexOf(String text, String ... values) {
        int answer = -1;
        for (String value : values) {
            int idx = text.indexOf(value);
            if (idx < 0 || answer >= 0 && idx >= answer) continue;
            answer = idx;
        }
        return answer;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getStringProxyURL() {
        return this.stringProxyURL;
    }

    public HttpClient createHttpClient(HttpMethod httpMethodProxyRequest) {
        HttpClient client = new HttpClient();
        return client;
    }

    public String getProxyHostAndPort() {
        return this.proxyHostAndPort;
    }

    public String getProxyPath() {
        return this.proxyPath;
    }
}

