/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.gateway.model.HttpProxyRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonRuleBaseReader {
    private static final ObjectMapper OM = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(JsonRuleBaseReader.class);

    private JsonRuleBaseReader() {
    }

    public static Map<String, HttpProxyRule> parseJson(InputStream in) {
        JsonRuleBaseReader.chechNotNull(in);
        HashMap<String, HttpProxyRule> map = new HashMap<String, HttpProxyRule>();
        try {
            for (JsonNode node : JsonRuleBaseReader.getRuleBase(OM.readTree(in))) {
                String rule = node.get("rule").asText();
                HttpProxyRule httpProxyRule = new HttpProxyRule(rule);
                httpProxyRule.to(node.get("to").asText());
                map.put(rule, httpProxyRule);
            }
            HashMap<String, HttpProxyRule> i$ = map;
            return i$;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            JsonRuleBaseReader.safeClose(in);
        }
    }

    private static JsonNode getRuleBase(JsonNode json) {
        JsonNode rules = json.get("rulebase");
        if (rules == null) {
            throw new IllegalStateException("Could not locate the 'rulebase' property");
        }
        return rules;
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException e) {
            LOG.warn("Exception while trying to close JSON input stream", (Throwable)e);
        }
    }

    private static void chechNotNull(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
    }
}

