/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.support.vertx;

import io.fabric8.gateway.fabric.support.vertx.VertxService;
import io.fabric8.utils.Objects;
import io.fabric8.vertx.FabricVertexFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;

@ApplicationScoped
public class VertxServiceImpl
implements VertxService {
    private static final transient Logger LOG = LoggerFactory.getLogger(VertxServiceImpl.class);
    @Inject
    private FabricVertexFactory vertxFactory;
    private Vertx vertx;

    @PostConstruct
    public void activate() throws Exception {
        this.vertx = this.vertxFactory.createVertx();
        Objects.notNull((Object)this.vertx, (String)"vertx");
    }

    @PreDestroy
    public void deactivate() {
        if (this.vertx != null) {
            try {
                this.vertx.stop();
            }
            catch (Throwable e) {
                LOG.warn("Failed to stop vertx: " + e, e);
            }
            this.vertx = null;
        }
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }
}

