/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.support.http;

import io.fabric8.gateway.ServiceDTO;
import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.model.ServiceListSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.utils.Systems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMappingKubeCache
implements Runnable {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingKubeCache.class);
    private final ScheduledExecutorService serviceCacheExecutor = Executors.newSingleThreadScheduledExecutor();
    private KubernetesClient client;
    private final HttpMappingRule mappingRuleConfiguration;
    private final List<Map<String, String>> serviceSelectors;
    private List<String> contextPathsCache;

    public HttpMappingKubeCache(HttpMappingRule mappingRuleConfiguration, List<Map<String, String>> serviceSelectors) {
        this.mappingRuleConfiguration = mappingRuleConfiguration;
        this.serviceSelectors = serviceSelectors;
    }

    public void init() {
        String kubernetesMaster = Systems.getEnvVarOrSystemProperty((String)"KUBERNETES_MASTER", (String)"KUBERNETES_MASTER", null);
        KubernetesFactory factory = kubernetesMaster == null ? new KubernetesFactory("http://localhost:8585/") : new KubernetesFactory(kubernetesMaster);
        this.contextPathsCache = new ArrayList<String>();
        this.client = new KubernetesClient(factory);
        this.serviceCacheExecutor.scheduleWithFixedDelay(this, 0L, 5L, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.serviceCacheExecutor.shutdown();
    }

    protected static String paramValue(String paramValue) {
        return paramValue != null ? paramValue : "";
    }

    private boolean selectorMatch(Map<String, String> selector) {
        for (Map<String, String> serviceSelector : this.serviceSelectors) {
            boolean isMatch = true;
            for (String key : serviceSelector.keySet()) {
                if (selector.containsKey(key) && selector.get(key).equals(serviceSelector.get(key))) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.refreshServices();
    }

    public void refreshServices() {
        ArrayList<String> currentCache = new ArrayList<String>();
        currentCache.addAll(this.contextPathsCache);
        try {
            ServiceListSchema serviceListSchema = this.client.getServices();
            for (ServiceSchema schema : serviceListSchema.getItems()) {
                if (!this.selectorMatch(schema.getSelector())) continue;
                String contextPath = schema.getId();
                ServiceDTO dto = new ServiceDTO();
                dto.setId(schema.getId());
                dto.setContainer((String)schema.getSelector().get("container"));
                dto.setVersion((String)schema.getSelector().get("version"));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", HttpMappingKubeCache.paramValue(dto.getId()));
                params.put("container", HttpMappingKubeCache.paramValue(dto.getContainer()));
                params.put("version", HttpMappingKubeCache.paramValue(dto.getVersion()));
                String service = "http://localhost:" + schema.getPort() + "/" + schema.getId();
                List<String> services = Arrays.asList(service);
                if (!this.contextPathsCache.contains(contextPath)) {
                    LOG.info("Adding " + service);
                    this.contextPathsCache.add(contextPath);
                }
                this.mappingRuleConfiguration.updateMappingRules(false, contextPath, services, params, (ServiceDetails)dto);
                currentCache.remove(contextPath);
            }
            for (String contextPath : currentCache) {
                this.mappingRuleConfiguration.updateMappingRules(true, contextPath, null, null, null);
                LOG.info("Removing " + contextPath);
                this.contextPathsCache.remove(contextPath);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

