/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.support.http;

import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.gateway.handlers.http.MappedServices;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.internal.SimplePathTemplate;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMappingRuleBase
implements HttpMappingRule {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingRuleBase.class);
    private final SimplePathTemplate uriTemplate;
    private final String gatewayVersion;
    private final String enabledVersion;
    private final LoadBalancer loadBalancer;
    private final boolean reverseHeaders;
    private Map<String, MappedServices> mappingRules = new ConcurrentHashMap<String, MappedServices>();
    private Set<Runnable> changeListeners = new CopyOnWriteArraySet<Runnable>();

    public HttpMappingRuleBase(SimplePathTemplate uriTemplate, String gatewayVersion, String enabledVersion, LoadBalancer loadBalancer, boolean reverseHeaders) {
        this.uriTemplate = uriTemplate;
        this.gatewayVersion = gatewayVersion;
        this.enabledVersion = enabledVersion;
        this.loadBalancer = loadBalancer;
        this.reverseHeaders = reverseHeaders;
    }

    public static void populateUrlParams(Map<String, String> params, String service) {
        try {
            URL url = new URL(service);
            params.put("contextPath", url.getPath());
            params.put("protocol", url.getProtocol());
            params.put("host", url.getHost());
            params.put("port", "" + url.getPort());
        }
        catch (MalformedURLException e) {
            LOG.warn("Invalid URL '" + service + "'. " + e);
        }
    }

    public String toString() {
        return "HttpMappingRuleBase{uriTemplate=" + this.uriTemplate + ", loadBalancer=" + this.loadBalancer + ", enabledVersion='" + this.enabledVersion + '\'' + ", reverseHeaders=" + this.reverseHeaders + ", gatewayVersion='" + this.gatewayVersion + '\'' + '}';
    }

    public void appendMappedServices(Map<String, MappedServices> rules) {
        rules.putAll(this.mappingRules);
    }

    public String getGatewayVersion() {
        return this.gatewayVersion;
    }

    public SimplePathTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public void updateMappingRules(boolean remove, String path, List<String> services, Map<String, String> defaultParams, ServiceDetails serviceDetails) {
        SimplePathTemplate pathTemplate = this.getUriTemplate();
        if (pathTemplate != null) {
            boolean versionSpecificUri = pathTemplate.getParameterNames().contains("version");
            String versionId = defaultParams.get("version");
            if (!remove && Strings.isNotBlank((String)versionId) && !versionSpecificUri && this.gatewayVersion != null && !this.gatewayVersion.equals(versionId)) {
                remove = true;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (defaultParams != null) {
                params.putAll(defaultParams);
            }
            params.put("servicePath", path);
            for (String service : services) {
                HttpMappingRuleBase.populateUrlParams(params, service);
                String fullPath = pathTemplate.bindByNameNonStrict(params);
                if (remove) {
                    MappedServices rule = this.mappingRules.get(fullPath);
                    if (rule == null) continue;
                    List serviceUrls = rule.getServiceUrls();
                    serviceUrls.remove(service);
                    if (!serviceUrls.isEmpty()) continue;
                    this.mappingRules.remove(fullPath);
                    continue;
                }
                MappedServices mappedServices = new MappedServices(service, serviceDetails, this.loadBalancer, this.reverseHeaders);
                MappedServices oldRule = this.mappingRules.put(fullPath, mappedServices);
                if (oldRule == null) continue;
                mappedServices.getServiceUrls().addAll(oldRule.getServiceUrls());
            }
        }
        this.fireMappingRulesChanged();
    }

    public void addChangeListener(Runnable listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Runnable listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireMappingRulesChanged() {
        for (Runnable changeListener : this.changeListeners) {
            changeListener.run();
        }
    }
}

