/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.support.vertx;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.common.util.Objects;
import io.fabric8.gateway.fabric.support.vertx.VertxService;
import io.fabric8.vertx.FabricVertexFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;

@Service(value={VertxService.class})
@Component(name="io.fabric8.gateway.vertx", label="Fabric8 Gateway Vertx Service", immediate=true, metatype=false)
public class VertxServiceImpl
extends AbstractComponent
implements VertxService {
    private static final transient Logger LOG = LoggerFactory.getLogger(VertxServiceImpl.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setCurator", unbind="unsetCurator")
    private CuratorFramework curator;
    @Reference(referenceInterface=FabricVertexFactory.class)
    private FabricVertexFactory vertxFactory;
    private Vertx vertx;

    @Activate
    public void activate(ComponentContext context) throws Exception {
        this.vertx = this.vertxFactory.createVertx();
        Objects.notNull((Object)this.vertx, (String)"vertx");
    }

    @Modified
    public void updated() throws Exception {
    }

    @Deactivate
    public void deactivate() {
        if (this.vertx != null) {
            try {
                this.vertx.stop();
            }
            catch (Throwable e) {
                LOG.warn("Failed to stop vertx: " + e, e);
            }
            this.vertx = null;
        }
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public void unsetCurator(CuratorFramework curator) {
        this.curator = null;
    }

    void bindVertxFactory(FabricVertexFactory service) {
        this.vertxFactory = service;
    }

    void unbindVertxFactory(FabricVertexFactory service) {
        this.vertxFactory = null;
    }
}

