/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.stomp;

import io.fabric8.gateway.handlers.detecting.protocol.Ascii;
import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.Constants;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.buffer.Buffer;

public class StompFrame {
    public static final Buffer NO_DATA = new Buffer(new byte[0]);
    private Ascii action;
    private ArrayList<HeaderEntry> headerList;
    private HashMap<Ascii, Ascii> headerMap = new HashMap(16);
    private Buffer content = NO_DATA;

    public StompFrame() {
    }

    public StompFrame(Ascii action) {
        this.action = action;
    }

    public StompFrame clone() {
        StompFrame rc = new StompFrame(this.action);
        if (this.headerList != null) {
            rc.headerList = new ArrayList<HeaderEntry>(this.headerList);
            rc.headerMap = null;
        } else {
            rc.headerMap = new HashMap<Ascii, Ascii>(this.headerMap);
            rc.headerList = null;
        }
        rc.content = this.content;
        return rc;
    }

    public Ascii action() {
        return this.action;
    }

    public StompFrame action(Ascii action) {
        assert (action != null);
        this.action = action;
        return this;
    }

    public Buffer content() {
        return this.content;
    }

    public StompFrame content(Buffer content) {
        assert (content != null);
        this.content = content;
        return this;
    }

    public String contentAsString() {
        return this.content.getString(0, this.content.length(), "UTF-8");
    }

    public Map<Ascii, Ascii> headerMap() {
        return this.headerMap(Collections.EMPTY_SET);
    }

    public Map<Ascii, Ascii> headerMap(Set<Ascii> reversedHeaderHandling) {
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
            for (HeaderEntry HeaderEntry2 : this.headerList) {
                Ascii key = HeaderEntry2.getKey();
                Ascii old = this.headerMap.put(key, HeaderEntry2.getValue());
                if (old == null || reversedHeaderHandling.contains(key)) continue;
                this.headerMap.put(key, old);
            }
            this.headerList = null;
        }
        return this.headerMap;
    }

    public List<HeaderEntry> headerList() {
        if (this.headerList == null) {
            for (Map.Entry<Ascii, Ascii> entry : this.headerMap.entrySet()) {
                this.headerList.add(new HeaderEntry(entry.getKey(), entry.getValue()));
            }
            this.headerMap = null;
        }
        return this.headerList;
    }

    public void addHeader(Ascii key, Ascii value) {
        if (this.headerList != null) {
            this.headerList.add(0, new HeaderEntry(key, value));
        } else {
            this.headerMap.put(key, value);
        }
    }

    String getHeaderAsString(Ascii key) {
        Ascii header = this.getHeader(key);
        if (header != null) {
            return StompFrame.decodeHeader(header.toBuffer());
        }
        return null;
    }

    public Ascii getHeader(Ascii key) {
        if (this.headerList != null) {
            for (HeaderEntry HeaderEntry2 : this.headerList) {
                if (!HeaderEntry2.getKey().equals(key)) continue;
                return HeaderEntry2.getValue();
            }
            return null;
        }
        return this.headerMap.get(key);
    }

    public void clearHeaders() {
        if (this.headerList != null) {
            this.headerList.clear();
        } else {
            this.headerMap.clear();
        }
    }

    public void setHeaders(ArrayList<HeaderEntry> values) {
        this.headerList = values;
        this.headerMap = null;
    }

    public void addContentLengthHeader() {
        this.addHeader(Constants.CONTENT_LENGTH, new Ascii(Integer.toString(this.content.length())));
    }

    public static String decodeHeader(Buffer value) {
        if (value == null) {
            return null;
        }
        Buffer rc = new Buffer(value.length());
        int pos = 0;
        int max = value.length();
        while (pos < max) {
            if (BufferSupport.startsWith(value, pos, Constants.ESCAPE_ESCAPE_SEQ.toBuffer())) {
                rc.appendByte((byte)92);
                pos += 2;
                continue;
            }
            if (BufferSupport.startsWith(value, pos, Constants.COLON_ESCAPE_SEQ.toBuffer())) {
                rc.appendByte((byte)58);
                pos += 2;
                continue;
            }
            if (BufferSupport.startsWith(value, pos, Constants.NEWLINE_ESCAPE_SEQ.toBuffer())) {
                rc.appendByte((byte)10);
                pos += 2;
                continue;
            }
            rc.appendByte(value.getByte(pos));
            ++pos;
        }
        return rc.toString();
    }

    public static Ascii encodeHeader(String value) {
        if (value == null) {
            return null;
        }
        try {
            byte[] data = value.getBytes("UTF-8");
            Buffer rc = new Buffer(data.length);
            block7: for (byte d : data) {
                switch (d) {
                    case 92: {
                        rc.appendBuffer(Constants.ESCAPE_ESCAPE_SEQ.toBuffer());
                        continue block7;
                    }
                    case 58: {
                        rc.appendBuffer(Constants.COLON_ESCAPE_SEQ.toBuffer());
                        continue block7;
                    }
                    case 10: {
                        rc.appendBuffer(Constants.COLON_ESCAPE_SEQ.toBuffer());
                        continue block7;
                    }
                    default: {
                        rc.appendByte(d);
                    }
                }
            }
            return Ascii.ascii(rc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<Ascii, Ascii> encodeHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<Ascii, Ascii> rc = new HashMap<Ascii, Ascii>(headers.size());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            rc.put(StompFrame.encodeHeader(entry.getKey()), StompFrame.encodeHeader(entry.getValue()));
        }
        return rc;
    }

    public static class HeaderEntry {
        public final Ascii key;
        public final Ascii value;

        public HeaderEntry(Ascii key, Ascii value) {
            this.key = key;
            this.value = value;
        }

        public Ascii getKey() {
            return this.key;
        }

        public Ascii getValue() {
            return this.value;
        }

        public String toString() {
            return "" + this.key + "=" + this.value;
        }
    }
}

