/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.command;

import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQQueue;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQTempQueue;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQTempTopic;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQTopic;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.DataStructure;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;

public abstract class ActiveMQDestination
implements DataStructure,
Comparable {
    public static final String PATH_SEPERATOR = ".";
    public static final char COMPOSITE_SEPERATOR = ',';
    public static final byte QUEUE_TYPE = 1;
    public static final byte TOPIC_TYPE = 2;
    public static final byte TEMP_MASK = 4;
    public static final byte TEMP_TOPIC_TYPE = 6;
    public static final byte TEMP_QUEUE_TYPE = 5;
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    public static final String TEMP_DESTINATION_NAME_PREFIX = "ID:";
    private static final long serialVersionUID = -3885260014960795889L;
    protected UTF8Buffer physicalName;

    public ActiveMQDestination() {
    }

    protected ActiveMQDestination(String name) {
        this.setPhysicalName(new UTF8Buffer(name));
    }

    public static ActiveMQDestination createDestination(String name) {
        if (name.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            return new ActiveMQQueue(name.substring(QUEUE_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TOPIC_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            return new ActiveMQTempQueue(name.substring(TEMP_QUEUE_QUALIFED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            return new ActiveMQTempTopic(name.substring(TEMP_TOPIC_QUALIFED_PREFIX.length()));
        }
        return null;
    }

    public static int compare(ActiveMQDestination destination, ActiveMQDestination destination2) {
        if (destination == destination2) {
            return 0;
        }
        if (destination == null) {
            return -1;
        }
        if (destination2 == null) {
            return 1;
        }
        if (destination.isQueue() == destination2.isQueue()) {
            return destination.getPhysicalName().compareTo((Buffer)destination2.getPhysicalName());
        }
        return destination.isQueue() ? -1 : 1;
    }

    public int compareTo(Object that) {
        if (that instanceof ActiveMQDestination) {
            return ActiveMQDestination.compare(this, (ActiveMQDestination)that);
        }
        if (that == null) {
            return 1;
        }
        return this.getClass().getName().compareTo(that.getClass().getName());
    }

    public abstract String getQualifiedPrefix();

    public UTF8Buffer getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(UTF8Buffer physicalName) {
        this.physicalName = physicalName;
    }

    public abstract byte getDestinationType();

    public boolean isQueue() {
        return false;
    }

    public boolean isTopic() {
        return false;
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveMQDestination d = (ActiveMQDestination)o;
        return this.physicalName.equals((Buffer)d.physicalName);
    }

    public int hashCode() {
        return this.physicalName.hashCode();
    }

    public String toString() {
        return this.physicalName.toString();
    }

    public String getDestinationTypeAsString() {
        switch (this.getDestinationType()) {
            case 1: {
                return "Queue";
            }
            case 2: {
                return "Topic";
            }
            case 5: {
                return "TempQueue";
            }
            case 6: {
                return "TempTopic";
            }
        }
        throw new IllegalArgumentException("Invalid destination type: " + this.getDestinationType());
    }

    @Override
    public boolean isMarshallAware() {
        return false;
    }
}

