/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.v1;

import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.BooleanStream;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.OpenWireFormat;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.v1.TransactionIdMarshaller;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.DataStructure;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.XATransactionId;
import java.io.IOException;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class XATransactionIdMarshaller
extends TransactionIdMarshaller {
    @Override
    public byte getDataStructureType() {
        return 112;
    }

    @Override
    public DataStructure createObject() {
        return new XATransactionId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        XATransactionId info = (XATransactionId)o;
        info.setFormatId(dataIn.readInt());
        info.setGlobalTransactionId(this.tightUnmarshalByteArray(dataIn, bs));
        info.setBranchQualifier(this.tightUnmarshalByteArray(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        XATransactionId info = (XATransactionId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalByteArray1(info.getGlobalTransactionId(), bs);
        return (rc += this.tightMarshalByteArray1(info.getBranchQualifier(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        XATransactionId info = (XATransactionId)o;
        dataOut.writeInt(info.getFormatId());
        this.tightMarshalByteArray2(info.getGlobalTransactionId(), dataOut, bs);
        this.tightMarshalByteArray2(info.getBranchQualifier(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        XATransactionId info = (XATransactionId)o;
        info.setFormatId(dataIn.readInt());
        info.setGlobalTransactionId(this.looseUnmarshalByteArray(dataIn));
        info.setBranchQualifier(this.looseUnmarshalByteArray(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        XATransactionId info = (XATransactionId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getFormatId());
        this.looseMarshalByteArray(wireFormat, info.getGlobalTransactionId(), dataOut);
        this.looseMarshalByteArray(wireFormat, info.getBranchQualifier(), dataOut);
    }
}

