/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.amqp;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpEvent;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpHeader;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpProtocolDecoder;
import io.fabric8.gateway.handlers.loadbalancer.ConnectionParameters;
import java.lang.reflect.Field;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.EngineFactory;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.EngineFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.net.NetSocket;

public class AmqpProtocol
implements Protocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(AmqpProtocol.class);
    static final Buffer PROTOCOL_MAGIC = new Buffer(new byte[]{65, 77, 81, 80});
    int maxFrameSize = 0x6400000;
    private static final String[] SCHEMES = new String[]{"amqp", "amqp+nio"};

    @Override
    public String getProtocolName() {
        return "amqp";
    }

    @Override
    public String[] getProtocolSchemes() {
        return SCHEMES;
    }

    @Override
    public int getMaxIdentificationLength() {
        return PROTOCOL_MAGIC.length();
    }

    @Override
    public boolean matches(Buffer header) {
        if (header.length() < PROTOCOL_MAGIC.length()) {
            return false;
        }
        return BufferSupport.startsWith(header, PROTOCOL_MAGIC);
    }

    @Override
    public void snoopConnectionParameters(SocketWrapper socket, Buffer received, Handler<ConnectionParameters> handler) {
        AmqpProtocolDecoder h = new AmqpProtocolDecoder(this);
        handler.handle((Object)new ConnectionParameters());
    }

    public void experimentalSnoopConnectionParameters(final NetSocket socket, Buffer received, final Handler<ConnectionParameters> handler) {
        AmqpProtocolDecoder h = new AmqpProtocolDecoder(this);
        final ConnectionParameters parameters = new ConnectionParameters();
        h.errorHandler(new Handler<String>(){

            public void handle(String error) {
                LOG.info("STOMP protocol decoding error: " + error);
                socket.close();
            }
        });
        h.codecHandler(new Handler<AmqpEvent>(){
            EngineFactory engineFactory = new EngineFactoryImpl();
            Transport protonTransport = this.engineFactory.createTransport();
            Connection protonConnection = this.engineFactory.createConnection();
            Sasl sasl;

            public void handle(AmqpEvent event) {
                switch (event.type) {
                    case HEADER: {
                        AmqpHeader header = (AmqpHeader)event.decodedFrame;
                        switch (header.getProtocolId()) {
                            case 0: {
                                break;
                            }
                            case 3: {
                                this.sasl = this.protonTransport.sasl();
                                this.sasl.server();
                                break;
                            }
                        }
                        this.processEvent(event);
                        Buffer buffer = BufferSupport.toBuffer(this.protonTransport.getOutputBuffer());
                        this.protonTransport.outputConsumed();
                        socket.write(buffer);
                        break;
                    }
                    default: {
                        this.processEvent(event);
                    }
                }
            }

            private void processEvent(AmqpEvent event) {
                byte[] buffer = event.encodedFrame.getBytes();
                int offset = 0;
                int remaining = buffer.length;
                while (remaining > 0) {
                    try {
                        int count = this.protonTransport.input(buffer, offset, remaining);
                        offset += count;
                        remaining -= count;
                    }
                    catch (Throwable e) {
                        LOG.info("Could not decode AMQP frame: " + e, e);
                        socket.close();
                        return;
                    }
                    if (this.sasl != null && this.sasl.getRemoteMechanisms().length > 0) {
                        parameters.protocolVirtualHost = AmqpProtocol.getHostname(this.sasl);
                        if ("PLAIN".equals(this.sasl.getRemoteMechanisms()[0])) {
                            byte[] data = new byte[this.sasl.pending()];
                            this.sasl.recv(data, 0, data.length);
                            Buffer[] parts = BufferSupport.split(new Buffer(data), (byte)0);
                            if (parts.length > 0) {
                                parameters.protocolUser = parts[0].toString();
                            }
                            handler.handle((Object)parameters);
                        }
                    }
                    if (this.protonConnection.getLocalState() != EndpointState.UNINITIALIZED || this.protonConnection.getRemoteState() == EndpointState.UNINITIALIZED) continue;
                    parameters.protocolVirtualHost = this.protonConnection.getRemoteHostname();
                    handler.handle((Object)parameters);
                }
            }
        });
        socket.dataHandler((Handler)h);
        h.handle(received);
    }

    private static String getHostname(Sasl sasl) {
        try {
            Field hostname = sasl.getClass().getDeclaredField("_hostname");
            hostname.setAccessible(true);
            return (String)hostname.get(sasl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

