/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol;

import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import java.io.IOException;
import java.net.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public abstract class ProtocolDecoder<T>
implements Handler<Buffer> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProtocolDecoder.class);
    private String error;
    private Handler<T> codecHander;
    private Handler<String> errorHandler;
    protected Buffer buff = null;
    protected long bytesDecoded;
    protected int readStart;
    protected Action<T> nextDecodeAction;
    protected int readEnd;

    protected abstract Action<T> initialDecodeAction();

    public ProtocolDecoder<T> codecHandler(Handler<T> codecHander) {
        this.codecHander = codecHander;
        return this;
    }

    public ProtocolDecoder<T> errorHandler(Handler<String> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public void handle(Buffer event) {
        if (this.error == null) {
            if (this.buff == null) {
                this.buff = event;
            } else {
                this.buff.appendBuffer(event);
            }
            try {
                T rc = this.read();
                while (rc != null) {
                    this.codecHander.handle(rc);
                    rc = this.read();
                }
            }
            catch (Exception e) {
                LOG.debug("Protocol decoding failure: " + e, (Throwable)e);
                this.error = e.getMessage();
                this.errorHandler.handle((Object)this.error);
            }
        }
    }

    public T read() throws IOException {
        T command = null;
        if (this.buff != null && this.readEnd < this.buff.length()) {
            if (this.nextDecodeAction == null) {
                this.nextDecodeAction = this.initialDecodeAction();
            }
            command = this.nextDecodeAction.apply();
            if (this.readStart == this.buff.length()) {
                this.buff = null;
                this.readEnd -= this.readStart;
                this.readStart = 0;
            } else if (this.readStart > 4096) {
                this.buff = this.buff.getBuffer(this.readStart, this.buff.length());
                this.readEnd -= this.readStart;
                this.readStart = 0;
            }
            assert (this.readStart <= this.readEnd);
        }
        return command;
    }

    protected Buffer readUntil(Byte octet) throws ProtocolException {
        return this.readUntil(octet, -1);
    }

    protected Buffer readUntil(Byte octet, int max) throws ProtocolException {
        return this.readUntil(octet, max, "Maximum protocol buffer length exceeded");
    }

    protected Buffer readUntil(byte octet, int max, String msg) throws ProtocolException {
        int pos = BufferSupport.indexOf(this.buff, this.readEnd, this.buff.length(), octet);
        if (pos >= 0) {
            int offset = this.readStart;
            this.readEnd = pos + 1;
            this.bytesDecoded += (long)(this.readEnd - this.readStart);
            this.readStart = this.readEnd;
            int length = this.readEnd - offset;
            if (max >= 0 && length > max) {
                throw new ProtocolException(msg);
            }
            return this.buff.getBuffer(offset, this.readEnd);
        }
        this.readEnd += this.buff.length();
        if (max >= 0 && this.readEnd - this.readStart > max) {
            throw new ProtocolException(msg);
        }
        return null;
    }

    protected Buffer readBytes(int length) {
        this.readEnd = this.readStart + length;
        if (this.buff.length() < this.readEnd) {
            return null;
        }
        this.bytesDecoded += (long)(this.readEnd - this.readStart);
        int offset = this.readStart;
        this.readStart = this.readEnd;
        return this.buff.getBuffer(offset, this.readEnd);
    }

    protected Buffer peekBytes(int length) {
        this.readEnd = this.readStart + length;
        if (this.buff.length() < this.readEnd) {
            return null;
        }
        return this.buff.getBuffer(this.readStart, this.readEnd);
    }

    public long getBytesDecoded() {
        return this.bytesDecoded;
    }

    public static interface Action<T> {
        public T apply() throws IOException;
    }
}

