/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.DetectingGateway;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.WebSocketBase;

public class DetectingGatewayWebSocketHandler
implements Handler<ServerWebSocket> {
    private static final transient Logger LOG = LoggerFactory.getLogger(DetectingGatewayWebSocketHandler.class);
    private final AtomicReference<DetectingGateway> gateway = new AtomicReference();
    private String pathPrefix;

    public void handle(ServerWebSocket socket) {
        DetectingGateway handler = this.gateway.get();
        if (handler == null) {
            LOG.info("Rejecting web socket: no protocol detecting gateway deployed");
            socket.reject();
            return;
        }
        if (this.pathPrefix != null && !socket.path().startsWith(this.pathPrefix)) {
            LOG.info("Rejecting web socket: request path does not start with:" + this.pathPrefix);
            socket.reject();
            return;
        }
        LOG.info("Processing the web socket '" + socket.remoteAddress() + "' with the protocol detecting gateway");
        handler.handle(SocketWrapper.wrap((WebSocketBase)socket));
    }

    public DetectingGateway getGateway() {
        return this.gateway.get();
    }

    public void setGateway(DetectingGateway value) {
        this.gateway.set(value);
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }
}

