/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.mqtt;

import io.fabric8.gateway.handlers.detecting.protocol.ProtocolDecoder;
import io.fabric8.gateway.handlers.detecting.protocol.mqtt.MqttProtocol;
import java.io.IOException;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

class MqttProtocolDecoder
extends ProtocolDecoder<MQTTFrame> {
    private static final transient Logger LOG = LoggerFactory.getLogger(MqttProtocolDecoder.class);
    private final MqttProtocol protocol;
    private final ProtocolDecoder.Action<MQTTFrame> readHeader = new ProtocolDecoder.Action<MQTTFrame>(){

        @Override
        public MQTTFrame apply() throws IOException {
            int length = MqttProtocolDecoder.this.readLength();
            if (length >= 0) {
                if (length > ((MqttProtocolDecoder)MqttProtocolDecoder.this).protocol.maxMessageLength) {
                    throw new IOException("The maximum message length was exceeded");
                }
                byte header = MqttProtocolDecoder.this.buff.getByte(MqttProtocolDecoder.this.readStart);
                int headerSize = MqttProtocolDecoder.this.readEnd - MqttProtocolDecoder.this.readStart;
                MqttProtocolDecoder.this.bytesDecoded += headerSize;
                MqttProtocolDecoder.this.readStart = MqttProtocolDecoder.this.readEnd;
                if (length > 0) {
                    MqttProtocolDecoder.this.nextDecodeAction = MqttProtocolDecoder.this.readBody(header, length);
                    return (MQTTFrame)MqttProtocolDecoder.this.nextDecodeAction.apply();
                }
                return new MQTTFrame().header(header);
            }
            return null;
        }
    };

    public MqttProtocolDecoder(MqttProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    protected ProtocolDecoder.Action<MQTTFrame> initialDecodeAction() {
        return this.readHeader;
    }

    private int readLength() throws IOException {
        this.readEnd = this.readStart + 2;
        int limit = this.buff.length();
        int length = 0;
        int multiplier = 1;
        while (this.readEnd - 1 < limit) {
            byte digit = this.buff.getByte(this.readEnd - 1);
            length += (digit & 0x7F) * multiplier;
            if ((digit & 0x80) == 0) {
                return length;
            }
            multiplier <<= 7;
            ++this.readEnd;
        }
        return -1;
    }

    ProtocolDecoder.Action<MQTTFrame> readBody(final byte header, final int remaining) {
        return new ProtocolDecoder.Action<MQTTFrame>(){

            @Override
            public MQTTFrame apply() throws IOException {
                Buffer body = MqttProtocolDecoder.this.readBytes(remaining);
                if (body == null) {
                    return null;
                }
                MqttProtocolDecoder.this.nextDecodeAction = MqttProtocolDecoder.this.readHeader;
                return new MQTTFrame(new org.fusesource.hawtbuf.Buffer(body.getBytes())).header(header);
            }
        };
    }
}

