/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.HttpPool;
import org.vertx.java.core.impl.ConcurrentHashSet;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public abstract class PriorityHttpConnectionPool
implements HttpPool {
    private static final Logger log = LoggerFactory.getLogger(PriorityHttpConnectionPool.class);
    private final Set<ClientConnection> available = new HashSet<ClientConnection>();
    private final Set<ClientConnection> allConnections = new ConcurrentHashSet<ClientConnection>();
    private int maxPoolSize = 1;
    private int connectionCount;
    private final Queue<Waiter> waiters = new ArrayDeque<Waiter>();

    @Override
    public void setMaxPoolSize(int maxConnections) {
        this.maxPoolSize = maxConnections;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void report() {
        log.trace("available: " + this.available.size() + " connection count: " + this.connectionCount + " waiters: " + this.waiters.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getConnection(final Handler<ClientConnection> handler, Handler<Throwable> connectExceptionHandler, DefaultContext context) {
        ClientConnection conn;
        boolean connect = false;
        PriorityHttpConnectionPool priorityHttpConnectionPool = this;
        synchronized (priorityHttpConnectionPool) {
            conn = this.selectConnection(this.available, this.connectionCount, this.maxPoolSize);
            if (conn != null) {
            } else if (this.connectionCount < this.maxPoolSize) {
                connect = true;
                ++this.connectionCount;
            } else {
                this.waiters.add(new Waiter(handler, connectExceptionHandler, context));
            }
        }
        if (conn != null) {
            handler.handle(conn);
        } else if (connect) {
            this.connect(new Handler<ClientConnection>(){

                @Override
                public void handle(ClientConnection conn) {
                    PriorityHttpConnectionPool.this.allConnections.add(conn);
                    handler.handle(conn);
                }
            }, connectExceptionHandler, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ClientConnection conn) {
        Waiter waiter;
        PriorityHttpConnectionPool priorityHttpConnectionPool = this;
        synchronized (priorityHttpConnectionPool) {
            --this.connectionCount;
            if (conn != null) {
                this.allConnections.remove(conn);
            }
            if (this.connectionCount < this.maxPoolSize) {
                waiter = this.waiters.poll();
                if (waiter != null) {
                    ++this.connectionCount;
                }
            } else {
                waiter = null;
            }
        }
        if (waiter != null) {
            this.connect(waiter.handler, waiter.connectionExceptionHandler, waiter.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(final ClientConnection conn) {
        Waiter waiter;
        PriorityHttpConnectionPool priorityHttpConnectionPool = this;
        synchronized (priorityHttpConnectionPool) {
            waiter = this.waiters.poll();
            if (waiter == null) {
                this.available.add(conn);
            }
        }
        if (waiter != null) {
            final Waiter w = waiter;
            w.context.execute(new Runnable(){

                @Override
                public void run() {
                    w.handler.handle(conn);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PriorityHttpConnectionPool priorityHttpConnectionPool = this;
        synchronized (priorityHttpConnectionPool) {
            this.available.clear();
            this.waiters.clear();
        }
        for (ClientConnection conn : this.allConnections) {
            try {
                conn.actualClose();
            }
            catch (Throwable t) {
                log.error("Failed to close connection", t);
            }
        }
        this.allConnections.clear();
    }

    protected abstract void connect(Handler<ClientConnection> var1, Handler<Throwable> var2, DefaultContext var3);

    private ClientConnection selectConnection(Set<ClientConnection> available, int connectionCount, int maxPoolSize) {
        ClientConnection conn = null;
        if (!available.isEmpty()) {
            boolean useOccupiedConnections = connectionCount >= maxPoolSize;
            for (ClientConnection c : available) {
                if (c.getOutstandingRequestCount() == 0 && !c.isClosed()) {
                    conn = c;
                    break;
                }
                if (!useOccupiedConnections || conn != null && (conn.getOutstandingRequestCount() <= c.getOutstandingRequestCount() || c.isClosed())) continue;
                conn = c;
            }
            if (conn != null) {
                available.remove(conn);
            }
        }
        return conn;
    }

    private static class Waiter {
        final Handler<ClientConnection> handler;
        final Handler<Throwable> connectionExceptionHandler;
        final DefaultContext context;

        private Waiter(Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, DefaultContext context) {
            this.handler = handler;
            this.connectionExceptionHandler = connectionExceptionHandler;
            this.context = context;
        }
    }
}

