/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting;

import io.fabric8.common.util.Strings;
import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.ServiceMap;
import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.detecting.protocol.ssl.SslConfig;
import io.fabric8.gateway.handlers.detecting.protocol.ssl.SslSocketWrapper;
import io.fabric8.gateway.handlers.loadbalancer.ClientRequestFacadeFactory;
import io.fabric8.gateway.handlers.loadbalancer.ConnectionParameters;
import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.streams.Pump;
import org.vertx.java.core.streams.ReadStream;

public class DetectingGatewayProtocolHandler
implements Handler<SocketWrapper> {
    private static final transient Logger LOG = LoggerFactory.getLogger(DetectingGatewayProtocolHandler.class);
    Vertx vertx;
    ServiceMap serviceMap;
    LoadBalancer serviceLoadBalancer;
    String defaultVirtualHost;
    ArrayList<Protocol> protocols;
    int maxProtocolIdentificationLength;
    ClientRequestFacadeFactory clientRequestFacadeFactory = new ClientRequestFacadeFactory("PROTOCOL_SESSION_ID, PROTOCOL_CLIENT_ID, REMOTE_ADDRESS");
    final AtomicReference<InetSocketAddress> httpGateway = new AtomicReference();
    SslConfig sslConfig;
    SSLContext sslContext;
    SslSocketWrapper.ClientAuth clientAuth = SslSocketWrapper.ClientAuth.WANT;

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setServiceMap(ServiceMap serviceMap) {
        this.serviceMap = serviceMap;
    }

    public LoadBalancer getServiceLoadBalancer() {
        return this.serviceLoadBalancer;
    }

    public void setServiceLoadBalancer(LoadBalancer serviceLoadBalancer) {
        this.serviceLoadBalancer = serviceLoadBalancer;
    }

    public String getDefaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public void setDefaultVirtualHost(String defaultVirtualHost) {
        this.defaultVirtualHost = defaultVirtualHost;
    }

    public ArrayList<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(ArrayList<Protocol> protocols) {
        this.protocols = new ArrayList<Protocol>(protocols);
        int max = 0;
        for (Protocol protocol : protocols) {
            if (protocol.getMaxIdentificationLength() <= max) continue;
            max = protocol.getMaxIdentificationLength();
        }
        this.maxProtocolIdentificationLength = max;
    }

    public Collection<String> getProtocolNames() {
        ArrayList<String> rc = new ArrayList<String>(this.protocols.size());
        for (Protocol protocol : this.protocols) {
            rc.add(protocol.getProtocolName());
        }
        return rc;
    }

    @Override
    public void handle(final SocketWrapper socket) {
        ReadStream<ReadStream> readStream = socket.readStream();
        readStream.exceptionHandler(new Handler<Throwable>(){

            @Override
            public void handle(Throwable e) {
                LOG.info(String.format("Failed to route gateway client '%s' due to: %s", socket.remoteAddress(), e), e);
                socket.close();
            }
        });
        readStream.endHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                LOG.info(String.format("Gateway client '%s' closed the connection before it could be routed.", socket.remoteAddress()));
                socket.close();
            }
        });
        readStream.dataHandler(new Handler<Buffer>(){
            Buffer received = new Buffer();

            @Override
            public void handle(Buffer event) {
                this.received.appendBuffer(event);
                for (final Protocol protocol : DetectingGatewayProtocolHandler.this.protocols) {
                    if (!protocol.matches(this.received)) continue;
                    if ("ssl".equals(protocol.getProtocolName())) {
                        LOG.info(String.format("SSL Connection from '%s'", socket.remoteAddress()));
                        String disabledCypherSuites = null;
                        String enabledCipherSuites = null;
                        if (DetectingGatewayProtocolHandler.this.sslConfig != null) {
                            disabledCypherSuites = DetectingGatewayProtocolHandler.this.sslConfig.getDisabledCypherSuites();
                            enabledCipherSuites = DetectingGatewayProtocolHandler.this.sslConfig.getEnabledCipherSuites();
                        }
                        if (DetectingGatewayProtocolHandler.this.sslContext == null) {
                            try {
                                if (DetectingGatewayProtocolHandler.this.sslConfig != null) {
                                    DetectingGatewayProtocolHandler.this.sslContext = SSLContext.getInstance(DetectingGatewayProtocolHandler.this.sslConfig.getProtocol());
                                    DetectingGatewayProtocolHandler.this.sslContext.init(DetectingGatewayProtocolHandler.this.sslConfig.getKeyManagers(), DetectingGatewayProtocolHandler.this.sslConfig.getTrustManagers(), null);
                                } else {
                                    DetectingGatewayProtocolHandler.this.sslContext = SSLContext.getDefault();
                                }
                            }
                            catch (Exception e) {
                                LOG.warn("Could initialize SSL: " + e, (Throwable)e);
                                socket.close();
                                return;
                            }
                        }
                        SslSocketWrapper sslSocketWrapper = new SslSocketWrapper(socket);
                        sslSocketWrapper.putBackHeader(this.received);
                        sslSocketWrapper.initServer(DetectingGatewayProtocolHandler.this.sslContext, DetectingGatewayProtocolHandler.this.clientAuth, disabledCypherSuites, enabledCipherSuites);
                        DetectingGatewayProtocolHandler.this.handle(sslSocketWrapper);
                        return;
                    }
                    if ("http".equals(protocol.getProtocolName())) {
                        InetSocketAddress target = DetectingGatewayProtocolHandler.this.getHttpGateway();
                        if (target != null) {
                            try {
                                URI url = new URI("http://" + target.getHostString() + ":" + target.getPort());
                                LOG.info(String.format("Connecting '%s' to '%s:%d' using the http protocol", socket.remoteAddress(), url.getHost(), url.getPort()));
                                DetectingGatewayProtocolHandler.this.createClient(socket, url, this.received);
                                return;
                            }
                            catch (URISyntaxException e) {
                                LOG.warn("Could not build valid connect URI.", (Throwable)e);
                                socket.close();
                                return;
                            }
                        }
                        LOG.info("No http gateway available for the http protocol");
                        socket.close();
                        return;
                    }
                    protocol.snoopConnectionParameters(socket, this.received, new Handler<ConnectionParameters>(){

                        @Override
                        public void handle(ConnectionParameters connectionParameters) {
                            if (connectionParameters.protocol == null) {
                                connectionParameters.protocol = protocol.getProtocolName();
                            }
                            if (connectionParameters.protocolSchemes == null) {
                                connectionParameters.protocolSchemes = protocol.getProtocolSchemes();
                            }
                            DetectingGatewayProtocolHandler.this.route(socket, connectionParameters, received);
                        }
                    });
                    return;
                }
                if (this.received.length() >= DetectingGatewayProtocolHandler.this.maxProtocolIdentificationLength) {
                    LOG.info("Connection did not use one of the enabled protocols " + DetectingGatewayProtocolHandler.this.getProtocolNames());
                    socket.close();
                }
            }
        });
    }

    public void route(SocketWrapper socket, ConnectionParameters params, Buffer received) {
        NetClient client = null;
        if (params.protocolVirtualHost == null) {
            params.protocolVirtualHost = this.defaultVirtualHost;
        }
        HashSet<String> schemes = new HashSet<String>(Arrays.asList(params.protocolSchemes));
        if (params.protocolVirtualHost != null) {
            ClientRequestFacade clientRequestFacade;
            ServiceDetails serviceDetails;
            List<ServiceDetails> services = this.serviceMap.getServices(params.protocolVirtualHost);
            if (services.isEmpty() && !params.protocolVirtualHost.equals(this.defaultVirtualHost)) {
                params.protocolVirtualHost = this.defaultVirtualHost;
                services = this.serviceMap.getServices(params.protocolVirtualHost);
            }
            LOG.debug(String.format("%d services match the virtual host", services.size()));
            if (!services.isEmpty() && (serviceDetails = this.serviceLoadBalancer.choose(services, clientRequestFacade = this.clientRequestFacadeFactory.create(socket, params))) != null) {
                List<String> urlStrings = serviceDetails.getServices();
                LOG.debug("Selected service exposes the following URLS: {}", urlStrings);
                for (String urlString : urlStrings) {
                    if (!Strings.notEmpty((String)urlString)) continue;
                    try {
                        URI uri = new URI(urlString);
                        String urlProtocol = uri.getScheme();
                        if (!schemes.contains(urlProtocol)) continue;
                        LOG.info(String.format("Connecting '%s' requesting virtual host '%s' with client key '%s' to '%s:%d' using the %s protocol", socket.remoteAddress(), params.protocolVirtualHost, clientRequestFacade.getClientRequestKey(), uri.getHost(), uri.getPort(), params.protocol));
                        client = this.createClient(socket, uri, received);
                        break;
                    }
                    catch (URISyntaxException e) {
                        LOG.warn("Failed to parse URI: " + urlString + ". " + e, (Throwable)e);
                    }
                }
            }
        }
        if (client == null) {
            LOG.info(String.format("No endpoint available for virtual host '%s' and protocol %s", params.protocolVirtualHost, params.protocol));
            socket.close();
        }
    }

    private NetClient createClient(final SocketWrapper socketFromClient, URI url, final Buffer received) {
        return this.vertx.createNetClient().connect(url.getPort(), url.getHost(), new Handler<AsyncResult<NetSocket>>(){

            @Override
            public void handle(AsyncResult<NetSocket> asyncSocket) {
                final NetSocket socketToServer = asyncSocket.result();
                Handler<Void> endHandler = new Handler<Void>(){

                    @Override
                    public void handle(Void event) {
                        socketFromClient.close();
                        socketToServer.close();
                    }
                };
                Handler<Throwable> exceptionHandler = new Handler<Throwable>(){

                    @Override
                    public void handle(Throwable event) {
                        socketFromClient.close();
                        socketToServer.close();
                    }
                };
                socketFromClient.readStream().endHandler(endHandler);
                socketFromClient.readStream().exceptionHandler(exceptionHandler);
                socketToServer.endHandler(endHandler);
                socketToServer.exceptionHandler(exceptionHandler);
                socketToServer.write(received);
                Pump.createPump(socketToServer, socketFromClient.writeStream()).start();
                Pump.createPump(socketFromClient.readStream(), socketToServer).start();
            }
        });
    }

    public ServiceMap getServiceMap() {
        return this.serviceMap;
    }

    public InetSocketAddress getHttpGateway() {
        return this.httpGateway.get();
    }

    public void setHttpGateway(InetSocketAddress value) {
        this.httpGateway.set(value);
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }
}

