/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.vertx.java.core.dns.impl.netty.DnsQuestion;
import org.vertx.java.core.dns.impl.netty.DnsResource;
import org.vertx.java.core.dns.impl.netty.DnsResponse;
import org.vertx.java.core.dns.impl.netty.DnsResponseHeader;

public class DnsResponseDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    public static String readName(ByteBuf buf) {
        int position = -1;
        StringBuilder name = new StringBuilder();
        short len = buf.readUnsignedByte();
        while (buf.isReadable() && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                if (position == -1) {
                    position = buf.readerIndex() + 1;
                }
                buf.readerIndex((len & 0x3F) << 8 | buf.readUnsignedByte());
            } else {
                name.append(buf.toString(buf.readerIndex(), len, CharsetUtil.UTF_8)).append(".");
                buf.skipBytes(len);
            }
            len = buf.readUnsignedByte();
        }
        if (position != -1) {
            buf.readerIndex(position);
        }
        if (name.length() == 0) {
            return null;
        }
        return name.substring(0, name.length() - 1);
    }

    public static String getName(ByteBuf buf, int offset) {
        StringBuilder name = new StringBuilder();
        short len = buf.getUnsignedByte(offset++);
        while (buf.writerIndex() > offset && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                offset = (len & 0x3F) << 8 | buf.getUnsignedByte(offset++);
            } else {
                name.append(buf.toString(offset, len, CharsetUtil.UTF_8)).append(".");
                offset += len;
            }
            len = buf.getUnsignedByte(offset++);
        }
        if (name.length() == 0) {
            return null;
        }
        return name.substring(0, name.length() - 1);
    }

    private static DnsQuestion decodeQuestion(ByteBuf buf) {
        String name = DnsResponseDecoder.readName(buf);
        int type = buf.readUnsignedShort();
        int qClass = buf.readUnsignedShort();
        return new DnsQuestion(name, type, qClass);
    }

    private static DnsResource decodeResource(ByteBuf buf, ByteBufAllocator allocator) {
        String name = DnsResponseDecoder.readName(buf);
        int type = buf.readUnsignedShort();
        int aClass = buf.readUnsignedShort();
        long ttl = buf.readUnsignedInt();
        int len = buf.readUnsignedShort();
        ByteBuf resourceData = allocator.buffer(len);
        int contentIndex = buf.readerIndex();
        resourceData.writeBytes(buf, len);
        return new DnsResource(name, type, aClass, ttl, contentIndex, resourceData);
    }

    private static DnsResponseHeader decodeHeader(DnsResponse parent, ByteBuf buf) {
        int id = buf.readUnsignedShort();
        DnsResponseHeader header = new DnsResponseHeader(parent, id);
        int flags = buf.readUnsignedShort();
        header.setType(flags >> 15);
        header.setOpcode(flags >> 11 & 0xF);
        header.setRecursionDesired((flags >> 8 & 1) == 1);
        header.setAuthoritativeAnswer((flags >> 10 & 1) == 1);
        header.setTruncated((flags >> 9 & 1) == 1);
        header.setRecursionAvailable((flags >> 7 & 1) == 1);
        header.setZ(flags >> 4 & 7);
        header.setResponseCode(flags & 0xF);
        header.setReadQuestions(buf.readUnsignedShort());
        header.setReadAnswers(buf.readUnsignedShort());
        header.setReadAuthorityResources(buf.readUnsignedShort());
        header.setReadAdditionalResources(buf.readUnsignedShort());
        return header;
    }

    protected static DnsResponse decodeResponse(ByteBuf buf, ByteBufAllocator allocator) {
        int i;
        DnsResponse response = new DnsResponse(buf);
        DnsResponseHeader header = DnsResponseDecoder.decodeHeader(response, buf);
        response.setHeader(header);
        for (i = 0; i < header.getReadQuestions(); ++i) {
            response.addQuestion(DnsResponseDecoder.decodeQuestion(buf));
        }
        if (header.getResponseCode() != 0) {
            return response;
        }
        for (i = 0; i < header.getReadAnswers(); ++i) {
            response.addAnswer(DnsResponseDecoder.decodeResource(buf, allocator));
        }
        for (i = 0; i < header.getReadAuthorityResources(); ++i) {
            response.addAuthorityResource(DnsResponseDecoder.decodeResource(buf, allocator));
        }
        for (i = 0; i < header.getReadAdditionalResources(); ++i) {
            response.addAdditionalResource(DnsResponseDecoder.decodeResource(buf, allocator));
        }
        return response;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        out.add(DnsResponseDecoder.decodeResponse((ByteBuf)packet.content(), ctx.alloc()).retain());
    }
}

