/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.loadbalancer;

import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.RoundRobinLoadBalancer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StickyLoadBalancer<T>
implements LoadBalancer<T> {
    private final LoadBalancer<T> firstRequestLoadBalancer;
    private final int maximumCacheSize;
    private final Map<String, T> requestCache;

    public StickyLoadBalancer() {
        this(10000);
    }

    public StickyLoadBalancer(int maximumCacheSize) {
        this(maximumCacheSize, new RoundRobinLoadBalancer());
    }

    public StickyLoadBalancer(int maximumCacheSize, LoadBalancer<T> firstRequestLoadBalancer) {
        this.firstRequestLoadBalancer = firstRequestLoadBalancer;
        this.maximumCacheSize = maximumCacheSize;
        this.requestCache = new LinkedHashMap(maximumCacheSize + 1, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > StickyLoadBalancer.this.maximumCacheSize;
            }
        };
    }

    public String toString() {
        return "StickyLoadBalancer{maximumCacheSize=" + this.maximumCacheSize + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T choose(List<T> services, ClientRequestFacade requestFacade) {
        T answer;
        String clientKey = requestFacade.getClientRequestKey();
        Map<String, T> map = this.requestCache;
        synchronized (map) {
            answer = this.requestCache.get(clientKey);
            if (answer == null && (answer = this.firstRequestLoadBalancer.choose(services, requestFacade)) != null) {
                this.requestCache.put(clientKey, answer);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<String, T> map = this.requestCache;
        synchronized (map) {
            this.requestCache.clear();
        }
    }
}

