/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.impl.ssl.DefaultSslEngineFacade;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;

public class SslEngineFacadeFactory {
    private static final Logger _logger = Logger.getLogger(SslEngineFacadeFactory.class.getName());
    private static final String TLS_PROTOCOL = "TLS";
    private static final List<String> ANONYMOUS_CIPHER_SUITES;
    private SSLContext _sslContext;

    SslEngineFacadeFactory() {
    }

    public ProtonSslEngine createProtonSslEngine(SslDomain domain, SslPeerDetails peerDetails) {
        SSLEngine engine = this.createAndInitialiseSslEngine(domain, peerDetails);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Created SSL engine: " + this.engineToString(engine));
        }
        return new DefaultSslEngineFacade(engine);
    }

    public void resetCache() {
        this._sslContext = null;
    }

    private SSLEngine createAndInitialiseSslEngine(SslDomain domain, SslPeerDetails peerDetails) {
        SslDomain.Mode mode = domain.getMode();
        SSLContext sslContext = this.getOrCreateSslContext(domain);
        SSLEngine sslEngine = this.createSslEngine(sslContext, peerDetails);
        if (domain.getPeerAuthentication() == SslDomain.VerifyMode.ANONYMOUS_PEER) {
            this.addAnonymousCipherSuites(sslEngine);
        } else if (mode == SslDomain.Mode.SERVER) {
            sslEngine.setNeedClientAuth(true);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, mode + " Enabled cipher suites " + Arrays.asList(sslEngine.getEnabledCipherSuites()));
        }
        boolean useClientMode = mode == SslDomain.Mode.CLIENT;
        sslEngine.setUseClientMode(useClientMode);
        return sslEngine;
    }

    private SSLEngine createSslEngine(SSLContext sslContext, SslPeerDetails sslPeerDetails) {
        SSLEngine sslEngine = sslPeerDetails == null ? sslContext.createSSLEngine() : sslContext.createSSLEngine(sslPeerDetails.getHostname(), sslPeerDetails.getPort());
        return sslEngine;
    }

    private SSLContext getOrCreateSslContext(SslDomain sslDomain) {
        if (this._sslContext == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("lazily creating new SSLContext using domain " + sslDomain);
            }
            char[] dummyPassword = "unused-passphrase".toCharArray();
            try {
                TrustManager[] trustManagers;
                SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
                KeyStore ksKeys = this.createKeyStoreFrom(sslDomain, dummyPassword);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ksKeys, dummyPassword);
                if (sslDomain.getPeerAuthentication() == SslDomain.VerifyMode.ANONYMOUS_PEER) {
                    trustManagers = new TrustManager[]{new AlwaysTrustingTrustManager()};
                } else {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ksKeys);
                    trustManagers = tmf.getTrustManagers();
                }
                sslContext.init(kmf.getKeyManagers(), trustManagers, null);
                this._sslContext = sslContext;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Unexpected exception creating SSLContext", e);
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("Unexpected exception creating SSLContext", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IllegalStateException("Unexpected exception creating SSLContext", e);
            }
            catch (KeyManagementException e) {
                throw new IllegalStateException("Unexpected exception creating SSLContext", e);
            }
        }
        return this._sslContext;
    }

    private KeyStore createKeyStoreFrom(SslDomain sslDomain, char[] dummyPassword) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null, null);
            if (sslDomain.getTrustedCaDb() != null) {
                String caCertAlias = "cacert";
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "_sslParams.getTrustedCaDb() : " + sslDomain.getTrustedCaDb());
                }
                Certificate trustedCaCert = (Certificate)this.readPemObject(sslDomain.getTrustedCaDb(), null, Certificate.class);
                keystore.setCertificateEntry(caCertAlias, trustedCaCert);
            }
            if (sslDomain.getCertificateFile() != null && sslDomain.getPrivateKeyFile() != null) {
                PrivateKey clientPrivateKey;
                String clientPrivateKeyAlias = "clientPrivateKey";
                Certificate clientCertificate = (Certificate)this.readPemObject(sslDomain.getCertificateFile(), null, Certificate.class);
                Object keyOrKeyPair = this.readPemObject(sslDomain.getPrivateKeyFile(), sslDomain.getPrivateKeyPassword(), PrivateKey.class, KeyPair.class);
                if (keyOrKeyPair instanceof PrivateKey) {
                    clientPrivateKey = (PrivateKey)keyOrKeyPair;
                } else if (keyOrKeyPair instanceof KeyPair) {
                    clientPrivateKey = ((KeyPair)keyOrKeyPair).getPrivate();
                } else {
                    throw new IllegalStateException("Unexpected key type " + keyOrKeyPair);
                }
                keystore.setKeyEntry(clientPrivateKeyAlias, clientPrivateKey, dummyPassword, new Certificate[]{clientCertificate});
            }
            return keystore;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Unexpected exception creating keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected exception creating keystore", e);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Unexpected exception creating keystore", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected exception creating keystore", e);
        }
    }

    private void addAnonymousCipherSuites(SSLEngine sslEngine) {
        List<String> supportedSuites = Arrays.asList(sslEngine.getSupportedCipherSuites());
        List<String> currentEnabledSuites = Arrays.asList(sslEngine.getEnabledCipherSuites());
        List<String> enabledSuites = this.buildEnabledSuitesIncludingAnonymous(ANONYMOUS_CIPHER_SUITES, supportedSuites, currentEnabledSuites);
        sslEngine.setEnabledCipherSuites(enabledSuites.toArray(new String[0]));
    }

    private List<String> buildEnabledSuitesIncludingAnonymous(List<String> anonymousCipherSuites, List<String> supportedSuites, List<String> currentEnabled) {
        ArrayList<String> newEnabled = new ArrayList<String>(currentEnabled);
        int addedAnonymousCipherSuites = 0;
        for (String anonymousCipherSuiteName : anonymousCipherSuites) {
            if (!supportedSuites.contains(anonymousCipherSuiteName)) continue;
            newEnabled.add(anonymousCipherSuiteName);
            ++addedAnonymousCipherSuites;
        }
        if (addedAnonymousCipherSuites == 0) {
            throw new IllegalStateException("None of " + anonymousCipherSuites + " anonymous cipher suites are within the supported list " + supportedSuites);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("There are now " + newEnabled.size() + " cipher suites enabled (previously " + currentEnabled.size() + "), including " + addedAnonymousCipherSuites + " out of the " + anonymousCipherSuites.size() + " requested anonymous ones.");
        }
        return newEnabled;
    }

    private String engineToString(SSLEngine engine) {
        return "[ " + engine + ", needClientAuth=" + engine.getNeedClientAuth() + ", useClientMode=" + engine.getUseClientMode() + ", peerHost=" + engine.getPeerHost() + ", peerPort=" + engine.getPeerPort() + " ]";
    }

    private Object readPemObject(String pemFile, String keyPassword, Class ... expectedInterfaces) {
        PasswordFinder passwordFinder = keyPassword != null ? this.getPasswordFinderFor(keyPassword) : null;
        FileReader reader = null;
        PEMReader pemReader = null;
        try {
            reader = new FileReader(pemFile);
            pemReader = new PEMReader((Reader)reader, passwordFinder);
            Object pemObject = pemReader.readObject();
            if (!this.checkPemObjectIsOfAllowedTypes(pemObject, expectedInterfaces)) {
                throw new IllegalStateException("File " + pemFile + " does not provide a object of the required type." + " Read an object of class " + pemObject.getClass().getName() + " whilst expecting an implementation of one of the following  : " + Arrays.asList(expectedInterfaces));
            }
            Object object = pemObject;
            return object;
        }
        catch (PEMException e) {
            _logger.log(Level.SEVERE, "Unable to read PEM object. Perhaps you need the unlimited strength libraries in <java-home>/jre/lib/security/ ?", e);
            throw new IllegalStateException("Unable to read PEM object from file " + pemFile, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read PEM object from file " + pemFile, e);
        }
        finally {
            if (pemReader != null) {
                try {
                    pemReader.close();
                }
                catch (IOException e) {
                    _logger.log(Level.SEVERE, "Couldn't close PEM reader", e);
                }
            }
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    _logger.log(Level.SEVERE, "Couldn't close PEM file reader", e);
                }
            }
        }
    }

    private boolean checkPemObjectIsOfAllowedTypes(Object pemObject, Class ... expectedInterfaces) {
        if (expectedInterfaces.length == 0) {
            throw new IllegalArgumentException("Must be at least one expectedKeyTypes");
        }
        for (Class keyInterface : expectedInterfaces) {
            if (!keyInterface.isInstance(pemObject)) continue;
            return true;
        }
        return false;
    }

    private PasswordFinder getPasswordFinderFor(final String keyPassword) {
        PasswordFinder passwordFinder = new PasswordFinder(){

            public char[] getPassword() {
                return keyPassword.toCharArray();
            }
        };
        return passwordFinder;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ANONYMOUS_CIPHER_SUITES = Arrays.asList("TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
    }

    private final class AlwaysTrustingTrustManager
    implements X509TrustManager {
        private AlwaysTrustingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }
}

