/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.api.handlers.http;

import io.fabric8.gateway.api.CallDetailRecord;
import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.HttpGatewayServiceClient;
import io.fabric8.gateway.api.handlers.http.HttpMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpServerRequest;

public class HttpGatewayHandler
implements Handler<HttpServerRequest> {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpGatewayHandler.class);
    private HttpGatewayServiceClient httpGatewayClient;
    private final HttpGateway httpGateway;

    public HttpGatewayHandler(Vertx vertx, HttpGateway httpGateway) {
        this.httpGateway = httpGateway;
        this.httpGatewayClient = new HttpGatewayServiceClient(vertx, httpGateway);
    }

    public void handle(HttpServerRequest request) {
        if (HttpMapping.isMappingIndexRequest(request, this.httpGateway)) {
            HttpMapping.respond(request, this.httpGateway);
            return;
        }
        long callStart = System.nanoTime();
        final HttpClientRequest serviceRequest = this.httpGatewayClient.execute(request, null);
        request.dataHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer data) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxying request body:" + data);
                }
                serviceRequest.write(data);
            }
        });
        request.endHandler((Handler)new VoidHandler(){

            public void handle() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("end of the request");
                }
                serviceRequest.end();
            }
        });
        CallDetailRecord cdr = new CallDetailRecord(System.nanoTime() - callStart, request.response().getStatusMessage());
        this.httpGateway.addCallDetailRecord(cdr);
    }
}

