/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.api.handlers.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.IMappedServices;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class HttpMapping {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMapping.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void respond(HttpServerRequest request, HttpGateway httpGateway) {
        try {
            String json = HttpMapping.mappingRulesToJson(httpGateway.getMappedServices());
            HttpServerResponse httpServerResponse = request.response();
            httpServerResponse.headers().set("ContentType", "application/json");
            httpServerResponse.setStatusCode(200);
            httpServerResponse.end(json);
            httpServerResponse.close();
        }
        catch (Throwable e) {
            LOG.error("Caught: " + e, e);
            request.response().setStatusCode(404);
            StringWriter buffer = new StringWriter();
            e.printStackTrace(new PrintWriter(buffer));
            request.response().setStatusMessage("Error: " + e + "\nStack Trace: " + buffer);
            request.response().close();
        }
    }

    public static boolean isMappingIndexRequest(HttpServerRequest request, HttpGateway httpGateway) {
        if (httpGateway == null || !httpGateway.isEnableIndex()) {
            return false;
        }
        String uri = request.uri();
        return uri == null || uri.length() == 0 || request.path().equals("/");
    }

    protected static String mappingRulesToJson(Map<String, IMappedServices> rules) throws IOException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        Set<Map.Entry<String, IMappedServices>> entries = rules.entrySet();
        for (Map.Entry<String, IMappedServices> entry : entries) {
            String key = entry.getKey();
            IMappedServices value = entry.getValue();
            Set<String> serviceUrls = value.getServiceUrls();
            data.put(key, serviceUrls);
        }
        return mapper.writeValueAsString(data);
    }
}

