/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.api.handlers.http;

import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.IMappedServices;
import io.fabric8.gateway.api.handlers.http.ProxyMappingDetails;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class HttpGatewayServiceClient {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpGatewayServiceClient.class);
    private final Vertx vertx;
    private final HttpGateway httpGateway;

    public HttpGatewayServiceClient(Vertx vertx, HttpGateway httpGateway) {
        this.vertx = vertx;
        this.httpGateway = httpGateway;
    }

    public HttpClientRequest execute(HttpServerRequest request, Object apiManagerResponseHandler) {
        String uri = request.uri();
        String uri2 = null;
        if (!uri.endsWith("/")) {
            uri2 = uri + "/";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Proxying request: " + uri);
        }
        HttpClient client = null;
        String remaining = null;
        String prefix = null;
        String proxyServiceUrl = null;
        String reverseServiceUrl = null;
        Map<String, IMappedServices> mappingRules = this.httpGateway.getMappedServices();
        try {
            IMappedServices mappedServices = null;
            URL clientURL = null;
            Set<Map.Entry<String, IMappedServices>> entries = mappingRules.entrySet();
            for (Map.Entry<String, IMappedServices> entry : entries) {
                String path = entry.getKey();
                mappedServices = entry.getValue();
                String pathPrefix = path;
                if (!uri.startsWith(pathPrefix) && (uri2 == null || !uri2.startsWith(pathPrefix))) continue;
                int pathPrefixLength = pathPrefix.length();
                remaining = pathPrefixLength < uri.length() ? uri.substring(pathPrefixLength + 1) : null;
                proxyServiceUrl = mappedServices.chooseService(request);
                if (proxyServiceUrl == null) continue;
                try {
                    clientURL = new URL(proxyServiceUrl);
                    client = this.createClient(clientURL);
                    prefix = clientURL.getPath();
                    reverseServiceUrl = request.absoluteURI().resolve(pathPrefix).toString();
                    if (!reverseServiceUrl.endsWith("/")) break;
                    reverseServiceUrl = reverseServiceUrl.substring(0, reverseServiceUrl.length() - 1);
                    break;
                }
                catch (MalformedURLException e) {
                    LOG.warn("Failed to parse URL: " + proxyServiceUrl + ". " + e, (Throwable)e);
                }
            }
            if (client != null) {
                String servicePath;
                String string = servicePath = prefix != null ? prefix : "";
                if (servicePath.length() > 0 && !servicePath.endsWith("/")) {
                    servicePath = servicePath + "/";
                }
                if (remaining != null) {
                    servicePath = servicePath + remaining;
                }
                LOG.info("Proxying request " + uri + " to service path: " + servicePath + " on service: " + proxyServiceUrl + " reverseServiceUrl: " + reverseServiceUrl);
                HttpClient finalClient = client;
                Handler<HttpClientResponse> serviceResponseHandler = null;
                serviceResponseHandler = this.httpGateway.getApiManager().isApiManagerEnabled() ? this.httpGateway.getApiManager().getService().createServiceResponseHandler(finalClient, apiManagerResponseHandler) : new Handler<HttpClientResponse>(finalClient, request);
                if (mappedServices != null) {
                    ProxyMappingDetails proxyMappingDetails = new ProxyMappingDetails(proxyServiceUrl, reverseServiceUrl, servicePath);
                    serviceResponseHandler = mappedServices.wrapResponseHandlerInPolicies(request, serviceResponseHandler, proxyMappingDetails);
                }
                HttpClientRequest serviceRequest = client.request(request.method(), servicePath, serviceResponseHandler);
                serviceRequest.headers().set(request.headers());
                serviceRequest.setChunked(true);
                return serviceRequest;
            }
            LOG.info("Could not find matching proxy path for " + uri + " from paths: " + mappingRules.keySet());
            HttpServerResponse httpServerResponse = request.response();
            httpServerResponse.setStatusCode(404);
            httpServerResponse.setStatusMessage("Could not find matching proxy path for " + uri + " from paths: " + mappingRules.keySet());
            httpServerResponse.end();
        }
        catch (Throwable e) {
            LOG.error("Caught: " + e, e);
            request.response().setStatusCode(404);
            StringWriter buffer = new StringWriter();
            e.printStackTrace(new PrintWriter(buffer));
            request.response().setStatusMessage("Error: " + e + "\nStack Trace: " + buffer);
            request.response().close();
        }
        return null;
    }

    protected boolean isApimanagerRestRequest(HttpServerRequest request) {
        if (this.httpGateway == null || !this.httpGateway.isEnableIndex()) {
            return false;
        }
        String uri = request.uri();
        return uri == null || uri.length() == 0 || request.path().startsWith("/rest/apimanager/");
    }

    protected HttpClient createClient(URL url) throws MalformedURLException {
        HttpClient client = this.vertx.createHttpClient();
        client.setHost(url.getHost());
        client.setPort(url.getPort());
        return client;
    }
}

