/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.external;

import io.fabric8.kubernetes.api.model.EditableService;
import io.fabric8.kubernetes.api.model.EndpointsListBuilder;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceListBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.mock.KubernetesMockClient;
import io.fabric8.kubernetes.client.mock.MockNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.openshift.api.model.RouteListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.mock.OpenShiftMockClient;
import io.fabric8.spring.boot.Fabric8Application;
import java.net.MalformedURLException;
import java.net.URL;
import org.easymock.IExpectationSetters;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={Fabric8Application.class})
public class ClientFactory {
    @Bean
    public KubernetesClient getKubernetesClient(OpenShiftClient openShiftClient) throws MalformedURLException {
        KubernetesMockClient mock = new KubernetesMockClient();
        mock.getMasterUrl().andReturn((Object)new URL("https://kubernetes.default.svc")).anyTimes();
        mock.rootPaths().andReturn((Object)((RootPathsBuilder)new RootPathsBuilder().addToPaths(new String[]{"/api", "/api/v1beta3", "/api/v1", "/controllers", "/healthz", "/healthz/ping", "/logs/", "/metrics", "/ready", "/osapi", "/osapi/v1beta3", "/oapi", "/oapi/v1", "/swaggerapi/"})).build()).anyTimes();
        EditableService service1 = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service1")).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withPort(Integer.valueOf(80))).withNewTargetPort(Integer.valueOf(9090))).endPort()).endSpec()).build();
        EditableService service2 = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service2")).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withPort(Integer.valueOf(80))).withNewTargetPort(Integer.valueOf(8080))).endPort()).endSpec()).build();
        EditableService service3 = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service3")).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withPort(Integer.valueOf(443))).withNewTargetPort(Integer.valueOf(443))).endPort()).withPortalIP("172.30.17.2")).endSpec()).build();
        EditableService multiport = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("multiport")).endMetadata()).withNewSpec().addNewPort().withName("port1")).withProtocol("TCP")).withPort(Integer.valueOf(8081))).withNewTargetPort(Integer.valueOf(8081))).endPort()).addNewPort().withName("port2")).withProtocol("TCP")).withPort(Integer.valueOf(8082))).withNewTargetPort(Integer.valueOf(8082))).endPort()).addNewPort().withName("port3")).withProtocol("TCP")).withPort(Integer.valueOf(8083))).withNewTargetPort(Integer.valueOf(8083))).endPort()).withPortalIP("172.30.17.2")).endSpec()).build();
        ((IExpectationSetters)((MockResource)mock.services().withName("service1")).get()).andReturn((Object)service1).anyTimes();
        ((IExpectationSetters)((MockResource)mock.services().withName("service2")).get()).andReturn((Object)service2).anyTimes();
        ((IExpectationSetters)((MockResource)mock.services().withName("service3")).get()).andReturn((Object)service3).anyTimes();
        ((IExpectationSetters)((MockResource)mock.services().withName("multiport")).get()).andReturn((Object)multiport).anyTimes();
        ((IExpectationSetters)mock.services().list()).andReturn((Object)((ServiceListBuilder)new ServiceListBuilder().addToItems(new Service[]{service1, service2, service3, multiport})).build()).anyTimes();
        ((IExpectationSetters)mock.endpoints().list()).andReturn((Object)new EndpointsListBuilder().build()).anyTimes();
        mock.adapt(OpenShiftClient.class).andReturn((Object)this.getOpenShiftClient()).anyTimes();
        return mock.replay();
    }

    @Bean
    public OpenShiftClient getOpenShiftClient() {
        OpenShiftMockClient mock = new OpenShiftMockClient();
        ((IExpectationSetters)mock.routes().list()).andReturn((Object)new RouteListBuilder().build()).anyTimes();
        ((IExpectationSetters)((MockNonNamespaceOperation)mock.routes().inNamespace("default")).list()).andReturn((Object)new RouteListBuilder().build()).anyTimes();
        return mock.replay();
    }
}

