/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.converters;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.boot.converters.ServiceConverter;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;

@Configuration
public class CoverterServiceConfiguration {
    @Bean
    ServiceConverter serviceConverter(KubernetesClient client) {
        ServiceConverter converter = new ServiceConverter();
        converter.setKubernetesClient(client);
        return converter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ConversionService.class})
    public ConversionService conversionService(Set<GenericConverter> genericConverters) {
        ConversionServiceFactoryBean bean = new ConversionServiceFactoryBean();
        bean.setConverters(genericConverters);
        bean.afterPropertiesSet();
        return bean.getObject();
    }
}

