/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.internal;

import io.fabric8.kubernetes.api.model.EndpointsListBuilder;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.api.model.ServiceListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.mock.KubernetesMockClient;
import io.fabric8.kubernetes.client.mock.MockNonNamespaceOperation;
import io.fabric8.openshift.api.model.RouteListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.mock.OpenshiftMockClient;
import io.fabric8.spring.boot.Fabric8Application;
import java.net.MalformedURLException;
import java.net.URL;
import org.easymock.IExpectationSetters;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={Fabric8Application.class})
public class ClientFactory {
    @Bean
    public KubernetesClient getKubernetesClient(OpenShiftClient openShiftClient) throws MalformedURLException {
        KubernetesMockClient mock = new KubernetesMockClient();
        mock.getMasterUrl().andReturn((Object)new URL("https://kubernetes.default.svc")).anyTimes();
        mock.rootPaths().andReturn((Object)((RootPathsBuilder)new RootPathsBuilder().addToPaths(new String[]{"/api", "/api/v1beta3", "/api/v1", "/controllers", "/healthz", "/healthz/ping", "/logs/", "/metrics", "/ready", "/osapi", "/osapi/v1beta3", "/oapi", "/oapi/v1", "/swaggerapi/"})).build()).anyTimes();
        ((IExpectationSetters)mock.services().list()).andReturn((Object)new ServiceListBuilder().build()).anyTimes();
        ((IExpectationSetters)mock.endpoints().list()).andReturn((Object)new EndpointsListBuilder().build()).anyTimes();
        mock.adapt(OpenShiftClient.class).andReturn((Object)this.getOpenshiftClient()).anyTimes();
        return mock.replay();
    }

    @Bean
    public OpenShiftClient getOpenshiftClient() {
        OpenshiftMockClient mock = new OpenshiftMockClient();
        ((IExpectationSetters)mock.routes().list()).andReturn((Object)new RouteListBuilder().build()).anyTimes();
        ((IExpectationSetters)((MockNonNamespaceOperation)mock.routes().inNamespace("default")).list()).andReturn((Object)new RouteListBuilder().build()).anyTimes();
        return mock.replay();
    }
}

