/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.converters;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class ServiceToString
implements Converter<Service, String> {
    private final KubernetesClient kubernetesClient;

    public ServiceToString(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public String convert(Service source) {
        String serviceName = KubernetesHelper.getName((HasMetadata)source);
        String serviceNamespace = KubernetesHelper.getNamespace((HasMetadata)source);
        String serviceProtocol = this.getProtocolOfService(source);
        Boolean serviceExternal = this.isServiceExternal(source);
        return this.kubernetesClient.getServiceURL(serviceName, serviceNamespace, serviceProtocol, serviceExternal.booleanValue());
    }

    private String getProtocolOfService(Service service) {
        Object protocolProperty;
        String protocol = "tcp";
        if (service.getAdditionalProperties().containsKey("PROTOCOL") && (protocolProperty = service.getAdditionalProperties().get("PROTOCOL")) instanceof String) {
            protocol = (String)protocolProperty;
        }
        return protocol;
    }

    private Boolean isServiceExternal(Service service) {
        Object externalProperty;
        Boolean external = false;
        if (service.getAdditionalProperties().containsKey("EXTERNAL") && (externalProperty = service.getAdditionalProperties().get("EXTERNAL")) instanceof Boolean) {
            external = (Boolean)externalProperty;
        }
        return external;
    }
}

