/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.internal;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.spring.boot.AbstractServiceRegistar;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InternalServiceRegistar
extends AbstractServiceRegistar {
    private static final String SERVICE = "service";
    private static final String SERVICE_HOST_REGEX = "(?<service>[A-Z_]+)_SERVICE_HOST";
    private static final Pattern SERVICE_HOST_PATTERN = Pattern.compile("(?<service>[A-Z_]+)_SERVICE_HOST");
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    @Override
    public Service getService(String name) {
        String prefix = name.toUpperCase();
        Map<String, String> env = System.getenv();
        String serviceHost = env.get(prefix + HOST_SUFFIX);
        String port = env.get(prefix + PORT_SUFFIX);
        String protocol = env.get(prefix + PORT_SUFFIX + "_" + port + PROTO_SUFFIX);
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withClusterIP(serviceHost)).addNewPort().withPort(Integer.valueOf(Integer.parseInt(port)))).withProtocol(protocol)).endPort()).endSpec()).build();
    }
}

