/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot;

import io.fabric8.annotations.Protocol;
import io.fabric8.annotations.ServiceName;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.boot.ClientFactory;
import io.fabric8.spring.boot.Fabric8Application;
import io.fabric8.spring.boot.URLToConnection;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes={ClientFactory.class, URLToConnection.class, Fabric8Application.class})
public class Fabric8ApplicationTest {
    @Autowired
    private KubernetesClient kubernetes;
    @Autowired
    @ServiceName(value="fabric8-console-service")
    private URLConnection consoleService;
    @Autowired
    @ServiceName(value="app-library")
    private String appLibraryService;
    @Autowired
    @ServiceName(value="kubernetes")
    @Protocol(value="http")
    private String kubernetesService;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("MY_CONFIG_TEST", "value1");
        System.setProperty("MY_OTHER_CONFIG_TEST", "value2");
        System.setProperty("FABRIC8_CONSOLE_SERVICE_PROTOCOL", "https");
        System.setProperty("KUBERNETES_PROTOCOL", "https");
        System.setProperty("kubernetes.namespace", "default");
        System.setProperty("kubernetes.trust.certificates", "true");
    }

    @Test
    public void testSpringBoot() {
        Assert.assertNotNull((Object)this.kubernetes);
        Assert.assertNotNull((Object)this.consoleService);
        Assert.assertNotNull((Object)this.appLibraryService);
        Assert.assertNotNull((Object)this.kubernetesService);
    }
}

