/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.boot.converters.KubernetesConverterServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ConversionServiceFactoryBean;

@Configuration
public class KubernetesClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesClientConfiguration.class);

    @Bean
    public KubernetesClient kubernetesClient() {
        LOGGER.debug("Trying to init {} by auto-configuration.", (Object)KubernetesClient.class.getSimpleName());
        return new DefaultKubernetesClient();
    }

    @Bean
    public ConversionServiceFactoryBean conversionService() {
        return new KubernetesConverterServiceFactory(this.kubernetesClient());
    }
}

