/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.internal;

import io.fabric8.annotations.PortName;
import io.fabric8.annotations.Protocol;
import io.fabric8.annotations.ServiceName;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.boot.Fabric8Application;
import io.fabric8.spring.boot.URLToConnection;
import io.fabric8.spring.boot.internal.MockConfigurer;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes={URLToConnection.class, Fabric8Application.class})
public class ApplicationInternalTest {
    @Autowired
    private KubernetesClient client;
    @Autowired
    @ServiceName(value="service1")
    private URLConnection service1;
    @Autowired
    @ServiceName(value="service2")
    private String service2;
    @Autowired
    @ServiceName(value="service3")
    @Protocol(value="http")
    private String service3;
    @Autowired
    @ServiceName(value="multiport")
    @PortName(value="port1")
    private String multiport;
    @Autowired
    @ServiceName(value="multiport")
    @PortName(value="port2")
    private String multiport2;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("SERVICE1_PROTOCOL", "https");
        System.setProperty("SERVICE2_PROTOCOL", "https");
        System.setProperty("SERVICE3_PROTOCOL", "https");
        MockConfigurer.configure();
        System.setProperty("kubernetes.namespace", "default");
        System.setProperty("kubernetes.trust.certificates", "true");
    }

    @Test
    public void testSpringBoot() {
        Assert.assertNotNull((Object)this.client);
        Assert.assertNotNull((Object)this.service1);
        Assert.assertNotNull((Object)this.service2);
        Assert.assertNotNull((Object)this.service3);
    }

    @Test
    public void testMultiport() {
        Assert.assertNotNull((Object)this.multiport);
        Assert.assertTrue((boolean)this.multiport.endsWith("8081"));
        Assert.assertNotNull((Object)this.multiport2);
        Assert.assertTrue((boolean)this.multiport2.endsWith("8082"));
    }
}

