/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.RecordedRequest;
import io.fabric8.annotations.Protocol;
import io.fabric8.annotations.ServiceName;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.spring.boot.Fabric8Application;
import java.net.URL;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes={Fabric8Application.class})
public class Fabric8ApplicationTest {
    private static final MockWebServer server = new MockWebServer();
    private static String SERVICES_JSON;
    private static String FABRIC8_CONSOLE_SERVICE_JSON;
    private static String KUBERNETES_SERVICE_JSON;
    private static String APP_LIBRARY_SERVICE_JSON;
    @Autowired
    private KubernetesClient kubernetes;
    @Autowired
    @ServiceName(value="fabric8")
    private Service consoleService;
    @Autowired
    @ServiceName(value="app-library")
    private String appLibraryService;
    @Autowired
    @ServiceName(value="kubernetes")
    @Protocol(value="http")
    private String kubernetesService;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("MY_CONFIG_TEST", "value1");
        System.setProperty("MY_OTHER_CONFIG_TEST", "value2");
        System.setProperty("FABRIC8_CONSOLE_SERVICE_PROTOCOL", "https");
        System.setProperty("KUBERNETES_PROTOCOL", "https");
        FABRIC8_CONSOLE_SERVICE_JSON = Resources.toString((URL)Fabric8ApplicationTest.class.getResource("/mock/fabric8-console-service.json"), (Charset)Charsets.UTF_8);
        KUBERNETES_SERVICE_JSON = Resources.toString((URL)Fabric8ApplicationTest.class.getResource("/mock/kubernetes-service.json"), (Charset)Charsets.UTF_8);
        APP_LIBRARY_SERVICE_JSON = Resources.toString((URL)Fabric8ApplicationTest.class.getResource("/mock/app-library-service.json"), (Charset)Charsets.UTF_8);
        SERVICES_JSON = Resources.toString((URL)Fabric8ApplicationTest.class.getResource("/mock/services.json"), (Charset)Charsets.UTF_8);
        server.setDispatcher(new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                if (request.getPath().equals("/api/v1beta3/services") || request.getPath().equals("/api/v1beta3/namespaces/default/services")) {
                    return new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(SERVICES_JSON);
                }
                if (request.getPath().equals("/api/v1beta3/namespaces/default/services/kubernetes")) {
                    return new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(KUBERNETES_SERVICE_JSON);
                }
                if (request.getPath().equals("/api/v1beta3/namespaces/default/services/app-library")) {
                    return new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(APP_LIBRARY_SERVICE_JSON);
                }
                if (request.getPath().equals("/api/v1beta3/namespaces/default/services/fabric8")) {
                    return new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(FABRIC8_CONSOLE_SERVICE_JSON);
                }
                if (request.getPath().equals("/osapi/v1beta3/namespaces/default/routes")) {
                    return new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody("{}");
                }
                if (request.getPath().equals("/api/v1beta3/namespaces/default/endpoints")) {
                    return new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody("{}");
                }
                return new MockResponse().setResponseCode(401);
            }
        });
        server.play();
        System.setProperty("kubernetes.master", "http://" + server.getHostName() + ":" + server.getPort());
        System.setProperty("KUBERNETES_TRUST_CERT", "true");
        System.setProperty("kubernetes.verify", "false");
    }

    @Test
    public void testSpringBoot() {
        Assert.assertNotNull((Object)this.kubernetes);
        Assert.assertNotNull((Object)this.consoleService);
        Assert.assertNotNull((Object)this.appLibraryService);
        Assert.assertNotNull((Object)this.kubernetesService);
    }
}

