/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.external;

import io.fabric8.annotations.ServiceName;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.spring.boot.KubernetesProperties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class ExternalServiceRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        KubernetesProperties kubernetesProperties = new KubernetesProperties();
        KubernetesFactory kubernetesFactory = new KubernetesFactory(kubernetesProperties.getKubernetesMasterUrl());
        Kubernetes kubernetes = kubernetesFactory.createKubernetes();
        for (Service service : kubernetes.getServices("default").getItems()) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(Service.class);
            beanDefinition.addQualifier(new AutowireCandidateQualifier(ServiceName.class, (Object)service.getMetadata().getName()));
            beanDefinition.getPropertyValues().addPropertyValue("id", (Object)service.getMetadata().getName());
            beanDefinition.getPropertyValues().addPropertyValue("port", (Object)((ServicePort)service.getSpec().getPorts().iterator().next()).getPort());
            beanDefinition.getPropertyValues().addPropertyValue("portalIP", (Object)service.getSpec().getPortalIP());
            beanDefinition.getPropertyValues().addPropertyValue("protocol", (Object)((ServicePort)service.getSpec().getPorts().iterator().next()).getProtocol());
            beanDefinition.getPropertyValues().addPropertyValue("containerPort", (Object)((ServicePort)service.getSpec().getPorts().iterator().next()).getTargetPort());
            beanDefinition.getPropertyValues().addPropertyValue("kind", (Object)service.getKind());
            registry.registerBeanDefinition(service.getMetadata().getName() + "-service-bean", (BeanDefinition)beanDefinition);
        }
    }
}

