/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.spring.boot.KubernetesProperties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Kubernetes.class})
@EnableConfigurationProperties(value={KubernetesProperties.class})
public class KubernetesAutoconfigure {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesAutoconfigure.class);
    @Inject
    private KubernetesProperties kubernetesProperties;

    @Bean(name={"kubernetes"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Kubernetes.class})
    public Kubernetes kubernetes() {
        LOGGER.debug("Trying to init {} by auto-configuration.", (Object)Kubernetes.class.getSimpleName());
        KubernetesFactory factory = new KubernetesFactory(this.kubernetesProperties.getKubernetesMasterUrl());
        return factory.createKubernetes();
    }
}

