/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.selenium;

import io.fabric8.selenium.WebDriverFacade;
import io.fabric8.utils.Millis;
import org.openqa.selenium.By;

public class ConsoleTests {
    protected static final By inputUsernameBy = By.id((String)"inputUsername");
    protected static final By inputPasswordBy = By.id((String)"inputPassword");
    protected static final By namespaceSelectBy = By.xpath((String)"//select[@ng-model='namespace']");

    public static void waitUntilLoggedIn(WebDriverFacade facade) {
        ConsoleTests.waitUntilLoggedIn(facade, "admin", "admin");
    }

    public static void waitUntilLoggedIn(WebDriverFacade facade, String userName, String password) {
        int i;
        String namespace = facade.getNamespace();
        facade.sleep(Millis.seconds((int)5));
        for (i = 0; i < 5; ++i) {
            try {
                facade.untilIsDisplayed(inputUsernameBy);
                continue;
            }
            catch (Throwable e) {
                facade.logWarn("Trying to reload the browser!");
                facade.getDriver().navigate().refresh();
            }
        }
        facade.form().clearAndSendKeys(inputUsernameBy, userName).clearAndSendKeys(inputPasswordBy, password).submit();
        facade.logInfo("Logged in - waiting for the browser initialise the web app");
        facade.sleep(Millis.seconds((int)5));
        facade.logInfo("Logged in!");
        for (i = 0; i < 5; ++i) {
            try {
                facade.untilIsEnabled(namespaceSelectBy);
                continue;
            }
            catch (Throwable e) {
                facade.logWarn("Trying to reload the browser!");
                facade.getDriver().navigate().refresh();
            }
        }
        facade.untilSelectedByVisibleText(namespaceSelectBy, namespace);
        facade.sleep(Millis.seconds((int)10));
        facade.logInfo("Viewing namespace: " + namespace);
    }
}

