/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.project.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.project.support.GitUtils;
import io.fabric8.project.support.UserDetails;
import io.fabric8.repo.git.CreateRepositoryDTO;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.RepositoryDTO;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import io.fabric8.utils.cxf.JsonHelper;
import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildConfigHelper.class);

    public static BuildConfig createAndApplyBuildConfig(KubernetesClient kubernetesClient, String namespace, String projectName, String cloneUrl) {
        BuildConfig buildConfig = BuildConfigHelper.createBuildConfig(kubernetesClient, namespace, projectName, cloneUrl);
        Controller controller = new Controller(kubernetesClient);
        controller.setNamespace(namespace);
        controller.applyBuildConfig(buildConfig, "from project " + projectName);
        return buildConfig;
    }

    public static BuildConfig createBuildConfig(KubernetesClient kubernetesClient, String namespace, String projectName, String cloneUrl) {
        LOG.info("Creating a BuildConfig for namespace: " + namespace + " project: " + projectName);
        String jenkinsUrl = BuildConfigHelper.getJenkinsServiceUrl(kubernetesClient, namespace);
        return Builds.createDefaultBuildConfig((String)projectName, (String)cloneUrl, (String)jenkinsUrl);
    }

    public static String getBuildConfigConsoleURL(KubernetesClient kubernetes, String consoleNamespace, BuildConfig buildConfig) {
        String consoleURL;
        String name = KubernetesHelper.getName((HasMetadata)buildConfig);
        String namespace = KubernetesHelper.getNamespace((HasMetadata)buildConfig);
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = consoleNamespace;
        }
        if (Strings.isNotBlank((String)(consoleURL = BuildConfigHelper.getFabric8ConsoleServiceUrl(kubernetes, namespace)))) {
            if (Strings.isNotBlank((String)name)) {
                return URLUtils.pathJoin((String[])new String[]{consoleURL, "workspaces", namespace, "projects", name});
            }
            return URLUtils.pathJoin((String[])new String[]{consoleURL, "workspaces", namespace});
        }
        return null;
    }

    private static String getJenkinsServiceUrl(KubernetesClient kubernetes, String namespace) {
        return KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"jenkins", (String)namespace, (String)"http", (boolean)true);
    }

    private static String getFabric8ConsoleServiceUrl(KubernetesClient kubernetes, String namespace) {
        return KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"fabric8", (String)namespace, (String)"http", (boolean)true);
    }

    public static CreateGitProjectResults importNewGitProject(KubernetesClient kubernetesClient, UserDetails userDetails, File basedir, String namespace, String projectName, String origin, String message, boolean apply) throws GitAPIException, JsonProcessingException {
        return BuildConfigHelper.importNewGitProject(kubernetesClient, userDetails, basedir, namespace, projectName, origin, message, apply, true);
    }

    public static CreateGitProjectResults importNewGitProject(KubernetesClient kubernetesClient, UserDetails userDetails, File basedir, String namespace, String projectName, String origin, String message, boolean apply, boolean useLocalGitAddress) throws GitAPIException, JsonProcessingException {
        String cloneUrl;
        GitUtils.disableSslCertificateChecks();
        InitCommand initCommand = Git.init();
        initCommand.setDirectory(basedir);
        Git git = initCommand.call();
        LOG.info("Initialised an empty git configuration repo at {}", (Object)basedir.getAbsolutePath());
        PersonIdent personIdent = userDetails.createPersonIdent();
        String user = userDetails.getUser();
        String address = userDetails.getAddress();
        String internalAddress = userDetails.getInternalAddress();
        String branch = userDetails.getBranch();
        GitRepoClient repoClient = userDetails.createRepoClient();
        CreateRepositoryDTO createRepository = new CreateRepositoryDTO();
        createRepository.setName(projectName);
        String fullName = null;
        RepositoryDTO repository = repoClient.createRepository(createRepository);
        if (repository != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got repository: " + JsonHelper.toJson((Object)repository));
            }
            fullName = repository.getFullName();
        }
        if (Strings.isNullOrBlank(fullName)) {
            fullName = user + "/" + projectName;
        }
        String htmlUrl = URLUtils.pathJoin((String[])new String[]{address, user, projectName});
        String localCloneUrl = URLUtils.pathJoin((String[])new String[]{internalAddress, user, projectName + ".git"});
        String defaultCloneUrl = cloneUrl = htmlUrl + ".git";
        if (useLocalGitAddress && Strings.isNotBlank((String)internalAddress)) {
            defaultCloneUrl = localCloneUrl;
        }
        GitUtils.configureBranch(git, branch, origin, defaultCloneUrl);
        GitUtils.addDummyFileToEmptyFolders(basedir);
        LOG.info("About to git commit and push to: " + defaultCloneUrl + " and remote name " + origin);
        GitUtils.doAddCommitAndPushFiles(git, userDetails, personIdent, branch, origin, message, true);
        BuildConfig buildConfig = apply ? BuildConfigHelper.createAndApplyBuildConfig(kubernetesClient, namespace, projectName, defaultCloneUrl) : BuildConfigHelper.createBuildConfig(kubernetesClient, namespace, projectName, defaultCloneUrl);
        return new CreateGitProjectResults(buildConfig, fullName, htmlUrl, localCloneUrl, cloneUrl);
    }

    public static class CreateGitProjectResults {
        private final BuildConfig buildConfig;
        private final String fullName;
        private final String htmlUrl;
        private final String remoteUrl;
        private final String cloneUrl;

        public CreateGitProjectResults(BuildConfig buildConfig, String fullName, String htmlUrl, String remoteUrl, String cloneUrl) {
            this.buildConfig = buildConfig;
            this.fullName = fullName;
            this.htmlUrl = htmlUrl;
            this.remoteUrl = remoteUrl;
            this.cloneUrl = cloneUrl;
        }

        public String toString() {
            return "CreateGitProjectResults{fullName='" + this.fullName + '\'' + ", htmlUrl='" + this.htmlUrl + '\'' + ", remoteUrl='" + this.remoteUrl + '\'' + ", cloneUrl='" + this.cloneUrl + '\'' + '}';
        }

        public BuildConfig getBuildConfig() {
            return this.buildConfig;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public String getCloneUrl() {
            return this.cloneUrl;
        }
    }
}

