/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.profiles;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ProfilesHelpers {
    public static final String DELETED = "#deleted#";
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    public static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static Properties readPropertiesFile(Path path) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            properties.load(is);
        }
        return properties;
    }

    public static JsonNode readJsonFile(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            JsonNode jsonNode = JSON_MAPPER.readTree(is);
            return jsonNode;
        }
    }

    public static JsonNode readYamlFile(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            JsonNode jsonNode = YAML_MAPPER.readTree(is);
            return jsonNode;
        }
    }

    public static byte[] toBytes(Properties properties) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            properties.store(os, null);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static byte[] toYamlBytes(JsonNode yaml) throws IOException {
        return YAML_MAPPER.writeValueAsBytes((Object)yaml);
    }

    public static byte[] toJsonBytes(JsonNode yaml) throws IOException {
        return JSON_MAPPER.writeValueAsBytes((Object)yaml);
    }

    public static void recusivelyCollectFileListing(ArrayList<String> rc, Path base, Path directory) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    ProfilesHelpers.recusivelyCollectFileListing(rc, base, path);
                    continue;
                }
                rc.add(base.relativize(path).toString());
            }
        }
    }

    public static void merge(Properties target, Properties source) {
        if (source.contains(DELETED)) {
            target.clear();
        } else {
            for (Map.Entry<Object, Object> entry : source.entrySet()) {
                if (DELETED.equals(entry.getValue())) {
                    target.remove(entry.getKey());
                    continue;
                }
                target.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static JsonNode merge(JsonNode target, JsonNode source) {
        if (target == null) {
            return source;
        }
        if (target.isArray() && source.isArray()) {
            ArrayNode copy = (ArrayNode)target.deepCopy();
            for (JsonNode n : source) {
                if (n.isTextual() && DELETED.equals(n.textValue())) {
                    copy = JsonNodeFactory.instance.arrayNode();
                    continue;
                }
                copy.add(n);
            }
            return copy;
        }
        if (target.isObject() && source.isObject()) {
            ObjectNode copy = (ObjectNode)target.deepCopy();
            if (source.get(DELETED) != null) {
                copy = JsonNodeFactory.instance.objectNode();
            } else {
                Iterator iterator = source.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if (DELETED.equals(key)) continue;
                    JsonNode value = source.get(key);
                    if (value.isTextual() && DELETED.equals(value.textValue())) {
                        copy.remove(key);
                        continue;
                    }
                    JsonNode original = target.get(key);
                    value = ProfilesHelpers.merge(original, value);
                    copy.set(key, value);
                }
            }
            return copy;
        }
        return source;
    }
}

