/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.profiles;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.profiles.ProfilesHelpers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;

public class Profiles {
    private final Path repository;

    public Profiles(Path repository) {
        this.repository = repository;
    }

    public void materialize(Path target, String ... profileNames) throws IOException {
        ArrayList<String> profileSearchOrder = new ArrayList<String>();
        for (String profileName : profileNames) {
            this.collectProfileNames(profileSearchOrder, profileName);
        }
        HashSet<String> files = new HashSet<String>();
        for (String profileName : profileSearchOrder) {
            files.addAll(this.listFiles(profileName));
        }
        System.out.println("profile search order" + profileSearchOrder);
        System.out.println("files: " + files);
        for (String file : files) {
            InputStream is = this.materializeFile(file, profileSearchOrder);
            Throwable throwable = null;
            try {
                Files.copy(is, target.resolve(file), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private InputStream materializeFile(String fileName, ArrayList<String> profileSearchOrder) throws IOException {
        if (fileName.endsWith(".properties")) {
            Properties properties = new Properties();
            for (String profile : profileSearchOrder) {
                Path path = this.getProfilePath(profile).resolve(fileName);
                if (!Files.exists(path, new LinkOption[0])) continue;
                ProfilesHelpers.merge(properties, ProfilesHelpers.readPropertiesFile(path));
            }
            return new ByteArrayInputStream(ProfilesHelpers.toBytes(properties));
        }
        if (fileName.endsWith(".json")) {
            JsonNode node = null;
            for (String profile : profileSearchOrder) {
                Path path = this.getProfilePath(profile).resolve(fileName);
                if (!Files.exists(path, new LinkOption[0])) continue;
                node = ProfilesHelpers.merge(node, ProfilesHelpers.readJsonFile(path));
            }
            return new ByteArrayInputStream(ProfilesHelpers.toJsonBytes(node));
        }
        if (fileName.endsWith(".yml")) {
            JsonNode node = null;
            for (String profile : profileSearchOrder) {
                Path path = this.getProfilePath(profile).resolve(fileName);
                if (!Files.exists(path, new LinkOption[0])) continue;
                node = ProfilesHelpers.merge(node, ProfilesHelpers.readYamlFile(path));
            }
            return new ByteArrayInputStream(ProfilesHelpers.toYamlBytes(node));
        }
        Path last = null;
        for (String profile : profileSearchOrder) {
            Path path = this.getProfilePath(profile).resolve(fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            last = path;
        }
        return Files.newInputStream(last, new OpenOption[0]);
    }

    private ArrayList<String> listFiles(String profileName) throws IOException {
        ArrayList<String> rc = new ArrayList<String>();
        Path dir = this.getProfilePath(profileName);
        ProfilesHelpers.recusivelyCollectFileListing(rc, dir, dir);
        return rc;
    }

    private void collectProfileNames(ArrayList<String> target, String profileName) throws IOException {
        if (target.contains(profileName)) {
            return;
        }
        Path path = this.getProfilePath(profileName);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("Profile directory does not exists: " + path);
        }
        Properties props = new Properties();
        Path agentProperties = path.resolve("io.fabric8.agent.properties");
        if (Files.exists(agentProperties, new LinkOption[0])) {
            props = ProfilesHelpers.readPropertiesFile(agentProperties);
        }
        String parents = props.getProperty("attribute.parents", "default".equals(profileName) ? "" : "default");
        for (String parent : parents.split(",")) {
            if ((parent = parent.trim()).isEmpty()) continue;
            this.collectProfileNames(target, parent);
        }
        target.add(profileName);
    }

    private Path getProfilePath(String profileName) {
        return this.repository.resolve(profileName.replaceAll("-", "/") + ".profile");
    }
}

