/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.watcher.standard;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.service.PodLogService;
import io.fabric8.maven.core.service.PortForwardService;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.IoUtil;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.core.util.SpringBootUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.watcher.api.BaseWatcher;
import io.fabric8.maven.watcher.api.WatcherContext;
import io.fabric8.utils.Closeables;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.project.MavenProject;

public class SpringBootWatcher
extends BaseWatcher {
    private static final String SPRING_BOOT_MAVEN_PLUGIN_GA = "org.springframework.boot:spring-boot-maven-plugin";
    private static final int DEFAULT_SERVER_PORT = 8080;

    public SpringBootWatcher(WatcherContext watcherContext) {
        super(watcherContext, "spring-boot");
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Set<HasMetadata> resources, PlatformMode mode) {
        return MavenUtil.hasPlugin((MavenProject)this.getContext().getProject(), (String)SPRING_BOOT_MAVEN_PLUGIN_GA);
    }

    public void watch(List<ImageConfiguration> configs, Set<HasMetadata> resources, PlatformMode mode) throws Exception {
        KubernetesClient kubernetes = this.getContext().getKubernetesClient();
        PodLogService.PodLogServiceContext logContext = new PodLogService.PodLogServiceContext.Builder().log((Logger)this.log).newPodLog(this.getContext().getNewPodLogger()).oldPodLog(this.getContext().getOldPodLogger()).build();
        new PodLogService(logContext).tailAppPodsLogs(kubernetes, this.getContext().getNamespace(), resources, false, null, true, null, false);
        String url = this.getServiceExposeUrl(kubernetes, resources);
        if (url == null) {
            url = this.getPortForwardUrl(resources);
        }
        if (url == null) {
            throw new IllegalStateException("Unable to open a channel to the remote pod.");
        }
        this.runRemoteSpringApplication(url);
    }

    private String getPortForwardUrl(Set<HasMetadata> resources) throws Exception {
        LabelSelector selector = KubernetesResourceUtil.getPodLabelSelector(resources);
        if (selector == null) {
            this.log.warn("Unable to determine a selector for application pods", new Object[0]);
            return null;
        }
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((MavenProject)this.getContext().getProject());
        PortForwardService portForwardService = this.getContext().getFabric8ServiceHub().getPortForwardService();
        int port = IoUtil.getFreeRandomPort();
        int containerPort = this.findSpringBootWebPort(properties);
        portForwardService.forwardPortAsync(this.getContext().getLogger(), selector, containerPort, port);
        return this.createForwardUrl(properties, port);
    }

    private int findSpringBootWebPort(Properties properties) {
        return PropertiesHelper.getInteger((Properties)properties, (String)"server.port", (Integer)8080);
    }

    private String createForwardUrl(Properties properties, int localPort) {
        String scheme = Strings.isNotBlank((String)properties.getProperty("server.ssl.key-store")) ? "https://" : "http://";
        String contextPath = properties.getProperty("server.context-path", "");
        return scheme + "localhost:" + localPort + contextPath;
    }

    private String getServiceExposeUrl(KubernetesClient kubernetes, Set<HasMetadata> resources) throws InterruptedException {
        long serviceUrlWaitTimeSeconds = Configs.asInt((String)this.getConfig(Config.serviceUrlWaitTimeSeconds));
        for (HasMetadata entity : resources) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            Resource serviceResource = (Resource)((NonNamespaceOperation)kubernetes.services().inNamespace(this.getContext().getNamespace())).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && Strings.isNotBlank((String)(url = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)s).get("fabric8.io/exposeUrl"))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!Strings.isNotBlank(url) || !url.startsWith("http")) continue;
            return url;
        }
        this.log.info("No exposed service found for connecting the dev tools", new Object[0]);
        return null;
    }

    private boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.toLowerCase().equals("true");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runRemoteSpringApplication(String url) {
        this.log.info("Running RemoteSpringApplication against endpoint: " + url, new Object[0]);
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((MavenProject)this.getContext().getProject());
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret", System.getProperty("spring.devtools.remote.secret"));
        if (Strings.isNullOrBlank((String)remoteSecret)) {
            this.log.warn("There is no `%s` property defined in your src/main/resources/application.properties. Please add one!", new Object[]{"spring.devtools.remote.secret"});
            throw new IllegalStateException("No spring.devtools.remote.secret property defined in application.properties or system properties");
        }
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) throw new IllegalStateException("ClassLoader must be a URLClassLoader but it is: " + classLoader.getClass().getName());
        URLClassLoader pluginClassLoader = (URLClassLoader)classLoader;
        URLClassLoader projectClassLoader = ClassUtil.createProjectClassLoader((MavenProject)this.getContext().getProject(), (Logger)this.log);
        URLClassLoader[] classLoaders = new URLClassLoader[]{projectClassLoader, pluginClassLoader};
        StringBuilder buffer = new StringBuilder("java -cp ");
        int count = 0;
        for (URLClassLoader urlClassLoader : classLoaders) {
            URL[] urLs;
            for (URL u : urLs = urlClassLoader.getURLs()) {
                if (count++ > 0) {
                    buffer.append(File.pathSeparator);
                }
                try {
                    URI uri = u.toURI();
                    File file = new File(uri);
                    buffer.append(file.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create classpath: " + e, e);
                }
            }
        }
        try {
            File devtools = this.getSpringBootDevToolsJar(this.getContext().getProject());
            buffer.append(File.pathSeparator);
            buffer.append(devtools.getCanonicalPath());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to include devtools in the classpath: " + e, e);
        }
        buffer.append(" -Dspring.devtools.remote.secret=");
        buffer.append(remoteSecret);
        buffer.append(" org.springframework.boot.devtools.RemoteSpringApplication ");
        buffer.append(url);
        try {
            String command = buffer.toString();
            this.log.debug("Running: " + command, new Object[0]);
            final Process process = Runtime.getRuntime().exec(command);
            final AtomicBoolean outputEnabled = new AtomicBoolean(true);
            Runtime.getRuntime().addShutdownHook(new Thread("fabric8:watch [spring-boot] shutdown hook"){

                @Override
                public void run() {
                    SpringBootWatcher.this.log.info("Terminating the Spring remote client...", new Object[0]);
                    outputEnabled.set(false);
                    process.destroy();
                }
            });
            PrefixedLogger logger = new PrefixedLogger("Spring-Remote", (Logger)this.log);
            Thread stdOutPrinter = this.startOutputProcessor((Logger)logger, process.getInputStream(), false, outputEnabled);
            Thread stdErrPrinter = this.startOutputProcessor((Logger)logger, process.getErrorStream(), true, outputEnabled);
            int status = process.waitFor();
            stdOutPrinter.join();
            stdErrPrinter.join();
            if (status == 0) return;
            this.log.warn("Process returned status: %s", new Object[]{status});
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run RemoteSpringApplication: " + e, e);
        }
    }

    protected Thread startOutputProcessor(final Logger logger, final InputStream inputStream, final boolean error, final AtomicBoolean outputEnabled) throws IOException {
        Thread printer = new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!outputEnabled.get()) continue;
                        if (error) {
                            logger.error("%s", new Object[]{line});
                            continue;
                        }
                        logger.info("%s", new Object[]{line});
                    }
                }
                catch (Exception e) {
                    if (outputEnabled.get()) {
                        logger.error("Failed to process " + (error ? "stderr" : "stdout") + " from spring-remote process: " + e, new Object[0]);
                    }
                }
                finally {
                    Closeables.closeQuietly((Reader)reader);
                }
            }
        };
        printer.start();
        return printer;
    }

    private File getSpringBootDevToolsJar(MavenProject project) throws IOException {
        String version = SpringBootUtil.getSpringBootDevToolsVersion((MavenProject)project);
        if (version == null) {
            throw new IllegalStateException("Unable to find the spring-boot version");
        }
        return this.getContext().getFabric8ServiceHub().getArtifactResolverService().resolveArtifact("org.springframework.boot", "spring-boot-devtools", version, "jar");
    }

    private static enum Config implements Configs.Key
    {
        serviceUrlWaitTimeSeconds{
            {
                this.d = "5";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

