/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.watcher.api;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.WatchService;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public class WatcherContext {
    private MavenProject project;
    private MavenSession session;
    private ProcessorConfig config;
    private String goalName;
    private Logger logger;
    private Logger newPodLogger;
    private Logger oldPodLogger;
    private PlatformMode mode;
    private OpenShiftBuildStrategy strategy;
    private boolean useProjectClasspath;
    private ServiceHub serviceHub;
    private WatchService.WatchContext watchContext;
    private BuildService.BuildContext buildContext;
    private String namespace;
    private KubernetesClient kubernetesClient;

    private WatcherContext() {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public String getGoalName() {
        return this.goalName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PlatformMode getMode() {
        return this.mode;
    }

    public OpenShiftBuildStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public ServiceHub getServiceHub() {
        return this.serviceHub;
    }

    public WatchService.WatchContext getWatchContext() {
        return this.watchContext;
    }

    public BuildService.BuildContext getBuildContext() {
        return this.buildContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public Logger getNewPodLogger() {
        return this.newPodLogger;
    }

    public Logger getOldPodLogger() {
        return this.oldPodLogger;
    }

    public static class Builder {
        private WatcherContext ctx = new WatcherContext();

        public Builder project(MavenProject project) {
            this.ctx.project = project;
            return this;
        }

        public Builder session(MavenSession session) {
            this.ctx.session = session;
            return this;
        }

        public Builder config(ProcessorConfig config) {
            this.ctx.config = config;
            return this;
        }

        public Builder goalName(String goalName) {
            this.ctx.goalName = goalName;
            return this;
        }

        public Builder logger(Logger logger) {
            this.ctx.logger = logger;
            return this;
        }

        public Builder newPodLogger(Logger newPodLogger) {
            this.ctx.newPodLogger = newPodLogger;
            return this;
        }

        public Builder oldPodLogger(Logger oldPodLogger) {
            this.ctx.oldPodLogger = oldPodLogger;
            return this;
        }

        public Builder mode(PlatformMode mode) {
            this.ctx.mode = mode;
            return this;
        }

        public Builder strategy(OpenShiftBuildStrategy strategy) {
            this.ctx.strategy = strategy;
            return this;
        }

        public Builder useProjectClasspath(boolean useProjectClasspath) {
            this.ctx.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public Builder serviceHub(ServiceHub serviceHub) {
            this.ctx.serviceHub = serviceHub;
            return this;
        }

        public Builder watchContext(WatchService.WatchContext watchContext) {
            this.ctx.watchContext = watchContext;
            return this;
        }

        public Builder buildContext(BuildService.BuildContext buildContext) {
            this.ctx.buildContext = buildContext;
            return this;
        }

        public Builder namespace(String namespace) {
            this.ctx.namespace = namespace;
            return this;
        }

        public Builder kubernetesClient(KubernetesClient kubernetesClient) {
            this.ctx.kubernetesClient = kubernetesClient;
            return this;
        }

        public WatcherContext build() {
            return this.ctx;
        }
    }
}

