/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.quarkus;

import io.fabric8.maven.core.util.BuildLabelUtil;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.api.support.BaseGenerator;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.project.MavenProject;

public class QuarkusGenerator
extends BaseGenerator {
    public QuarkusGenerator(GeneratorContext context) {
        super(context, "quarkus");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)"io.quarkus", (String)"quarkus-maven-plugin");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> existingConfigs, boolean prePackagePhase) throws MojoExecutionException {
        ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder().name(this.getImageName()).registry(this.getRegistry()).alias(this.getAlias()).buildConfig(this.createBuildConfig(prePackagePhase));
        existingConfigs.add(imageBuilder.build());
        return existingConfigs;
    }

    private BuildImageConfiguration createBuildConfig(boolean prePackagePhase) throws MojoExecutionException {
        BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().ports(Collections.singletonList(this.getConfig(Config.webPort)));
        BuildLabelUtil.addSchemaLabels((BuildImageConfiguration.Builder)buildBuilder, (MavenProject)this.getContext().getProject(), (PrefixedLogger)this.log);
        boolean isNative = Boolean.parseBoolean(this.getConfig(Config.nativeImage, "false"));
        Optional<String> fromConfigured = Optional.ofNullable(this.getFromAsConfigured());
        if (isNative) {
            buildBuilder.from(fromConfigured.orElse("registry.fedoraproject.org/fedora-minimal")).entryPoint(new Arguments.Builder().withParam("./" + this.findSingleFileThatEndsWith("-runner")).withParam("-Dquarkus.http.host=0.0.0.0").build()).workdir("/");
            if (!prePackagePhase) {
                buildBuilder.assembly(this.createAssemblyConfiguration("/", this::getNativeFileToInclude));
            }
        } else {
            buildBuilder.from(fromConfigured.orElse("openjdk:11")).entryPoint(new Arguments.Builder().withParam("java").withParam("-Dquarkus.http.host=0.0.0.0").withParam("-jar").withParam(this.findSingleFileThatEndsWith("-runner.jar")).build()).workdir("/opt");
            if (!prePackagePhase) {
                buildBuilder.assembly(this.createAssemblyConfiguration("/opt", this::getJvmFilesToInclude));
            }
        }
        this.addLatestTagIfSnapshot(buildBuilder);
        return buildBuilder.build();
    }

    private AssemblyConfiguration createAssemblyConfiguration(String targetDir, FileSetCreator fsCreator) throws MojoExecutionException {
        AssemblyConfiguration.Builder builder = new AssemblyConfiguration.Builder().targetDir(targetDir);
        Assembly assembly = new Assembly();
        FileSet fileSet = fsCreator.createFileSet();
        fileSet.setOutputDirectory(".");
        assembly.addFileSet(fileSet);
        builder.assemblyDef(assembly);
        return builder.build();
    }

    private FileSet getJvmFilesToInclude() throws MojoExecutionException {
        FileSet fileSet = this.getFileSetWithFileFromBuildThatEndsWith("-runner.jar");
        fileSet.addInclude("lib/**");
        fileSet.setFileMode("0640");
        return fileSet;
    }

    private FileSet getNativeFileToInclude() throws MojoExecutionException {
        FileSet fileSet = this.getFileSetWithFileFromBuildThatEndsWith("-runner");
        fileSet.setFileMode("0755");
        return fileSet;
    }

    private FileSet getFileSetWithFileFromBuildThatEndsWith(String suffix) throws MojoExecutionException {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(FileUtil.getRelativePath((File)this.getProject().getBasedir(), (File)this.getBuildDir()).getPath());
        fileSet.addInclude(this.findSingleFileThatEndsWith(suffix));
        return fileSet;
    }

    private String findSingleFileThatEndsWith(String suffix) throws MojoExecutionException {
        File buildDir = this.getBuildDir();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        if (file == null || file.length != 1) {
            throw new MojoExecutionException("Can't find single file with suffix '" + suffix + "' in " + buildDir + " (zero or more than one files found ending with '" + suffix + "')");
        }
        return file[0];
    }

    private File getBuildDir() {
        return new File(this.getProject().getBuild().getDirectory());
    }

    static interface FileSetCreator {
        public FileSet createFileSet() throws MojoExecutionException;
    }

    public static enum Config implements Configs.Key
    {
        webPort{
            {
                this.d = "8080";
            }
        }
        ,
        nativeImage{
            {
                this.d = "false";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

