/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.generator.openliberty;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.javaexec.FatJarDetector;
import io.fabric8.maven.generator.javaexec.JavaExecGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.project.MavenProject;

public class OpenLibertyGenerator
extends JavaExecGenerator {
    protected static final String LIBERTY_SELF_EXTRACTOR = "wlp.lib.extract.SelfExtractRun";
    protected static final String LIBERTY_RUNNABLE_JAR = "LIBERTY_RUNNABLE_JAR";
    protected static final String JAVA_APP_JAR = "JAVA_APP_JAR";
    private String runnableJarName = null;

    public OpenLibertyGenerator(GeneratorContext context) {
        super(context, "openliberty");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)"io.openliberty.tools", (String)"liberty-maven-plugin");
    }

    protected List<String> extractPorts() {
        ArrayList<String> ret = new ArrayList<String>();
        this.addPortIfValid(ret, this.getConfig((Configs.Key)JavaExecGenerator.Config.webPort, "9080"));
        this.addPortIfValid(ret, this.getConfig((Configs.Key)JavaExecGenerator.Config.jolokiaPort));
        this.addPortIfValid(ret, this.getConfig((Configs.Key)JavaExecGenerator.Config.prometheusPort));
        return ret;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) throws MojoExecutionException {
        Map ret = super.getEnv(prePackagePhase);
        if (this.runnableJarName != null) {
            ret.put(LIBERTY_RUNNABLE_JAR, this.runnableJarName);
            ret.put(JAVA_APP_JAR, this.runnableJarName);
        }
        return ret;
    }

    protected AssemblyConfiguration createAssembly() throws MojoExecutionException {
        AssemblyConfiguration.Builder builder = new AssemblyConfiguration.Builder().targetDir(this.getConfig((Configs.Key)JavaExecGenerator.Config.targetDir));
        this.addAssembly(builder);
        return builder.build();
    }

    protected void addAssembly(AssemblyConfiguration.Builder builder) throws MojoExecutionException {
        String assemblyRef = this.getConfig((Configs.Key)JavaExecGenerator.Config.assemblyRef);
        if (assemblyRef != null) {
            builder.descriptorRef(assemblyRef);
        } else {
            Assembly assembly = new Assembly();
            this.addAdditionalFiles(assembly);
            if (this.isFatJar()) {
                FatJarDetector.Result fatJar = this.detectFatJar();
                MavenProject project = this.getProject();
                if (fatJar == null) {
                    DependencySet dependencySet = new DependencySet();
                    dependencySet.addInclude(project.getGroupId() + ":" + project.getArtifactId());
                    assembly.addDependencySet(dependencySet);
                } else {
                    FileSet fileSet = this.getOutputDirectoryFileSet(fatJar, project);
                    if (LIBERTY_SELF_EXTRACTOR.equals(fatJar.getMainClass())) {
                        this.runnableJarName = fatJar.getArchiveFile().getName();
                    }
                    assembly.addFileSet(fileSet);
                }
            } else {
                builder.descriptorRef("artifact-with-dependencies");
            }
            builder.assemblyDef(assembly);
        }
    }

    private void addAdditionalFiles(Assembly assembly) {
        assembly.addFileSet(this.createFileSet("src/main/fabric8-includes/bin", "bin", "0755", "0755"));
        assembly.addFileSet(this.createFileSet("src/main/fabric8-includes", ".", "0644", "0755"));
        assembly.addFileSet(this.createFileSet("src/main/liberty/config", "src/wlp/config", "0644", "0755"));
    }

    private FileSet getOutputDirectoryFileSet(FatJarDetector.Result fatJar, MavenProject project) {
        FileSet fileSet = new FileSet();
        File buildDir = new File(project.getBuild().getDirectory());
        fileSet.setDirectory(FileUtil.getRelativePath((File)project.getBasedir(), (File)buildDir).getPath());
        fileSet.addInclude(FileUtil.getRelativePath((File)buildDir, (File)fatJar.getArchiveFile()).getPath());
        fileSet.setOutputDirectory(".");
        fileSet.setFileMode("0640");
        return fileSet;
    }

    private FileSet createFileSet(String sourceDir, String outputDir, String fileMode, String directoryMode) {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(sourceDir);
        fileSet.setOutputDirectory(outputDir);
        fileSet.setFileMode(fileMode);
        fileSet.setDirectoryMode(directoryMode);
        return fileSet;
    }
}

