/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.javaexec;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;

public class FatJarDetector {
    private File directory;
    private Result result;

    public FatJarDetector(String dir) {
        this.directory = new File(dir);
    }

    public Result scan() throws MojoExecutionException {
        if (this.result == null) {
            if (!this.directory.exists()) {
                return null;
            }
            String[] jarOrWars = this.directory.list((dir, name) -> name.endsWith(".war") || name.endsWith(".jar"));
            if (jarOrWars == null || jarOrWars.length == 0) {
                return null;
            }
            long maxSize = 0L;
            for (String jarOrWar : jarOrWars) {
                File archiveFile = new File(this.directory, jarOrWar);
                try (JarFile archive = new JarFile(archiveFile);){
                    long size;
                    String mainClass;
                    Manifest mf = archive.getManifest();
                    Attributes mainAttributes = mf.getMainAttributes();
                    if (mainAttributes == null || (mainClass = mainAttributes.getValue("Main-Class")) == null || (size = archiveFile.length()) <= maxSize) continue;
                    maxSize = size;
                    this.result = new Result(archiveFile, mainClass, mainAttributes);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot examine file " + archiveFile + " for the manifest");
                }
            }
        }
        return this.result;
    }

    public class Result {
        private final File archiveFile;
        private final String mainClass;
        private final Attributes attributes;

        public Result(File archiveFile, String mainClass, Attributes attributes) {
            this.archiveFile = archiveFile;
            this.mainClass = mainClass;
            this.attributes = attributes;
        }

        public File getArchiveFile() {
            return this.archiveFile;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public String getManifestEntry(String key) {
            return this.attributes.getValue(key);
        }
    }
}

