/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DeploymentConfigEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "fmp-openshift-deploymentconfig";
    private Boolean enableAutomaticTrigger = this.getValueFromConfig("fabric8.openshift.enableAutomaticTrigger", true);
    private Long openshiftDeployTimeoutSeconds = this.getOpenshiftDeployTimeoutInSeconds(3600L);

    public DeploymentConfigEnricher(MavenEnricherContext context) {
        super((EnricherContext)context, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode == PlatformMode.openshift) {
            boolean switchToDeployment = false;
            for (HasMetadata item : builder.buildItems()) {
                if (!(item instanceof Deployment) || this.useDeploymentforOpenShift()) continue;
                DeploymentConfig deploymentConfig = this.convert(item);
                KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)builder, (HasMetadata)item);
                builder.addToDeploymentConfigItems(new DeploymentConfig[]{deploymentConfig});
            }
        }
    }

    private DeploymentConfig convert(HasMetadata item) {
        Deployment resource = (Deployment)item;
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        builder.withMetadata(resource.getMetadata());
        DeploymentSpec spec = resource.getSpec();
        if (spec != null) {
            PodTemplateSpec template;
            Map matchLabels;
            LabelSelector selector;
            Integer revisionHistoryLimit;
            DeploymentConfigFluent.SpecNested specBuilder = builder.withNewSpec();
            Integer replicas = spec.getReplicas();
            if (replicas != null) {
                specBuilder.withReplicas(replicas);
            }
            if ((revisionHistoryLimit = spec.getRevisionHistoryLimit()) != null) {
                specBuilder.withRevisionHistoryLimit(revisionHistoryLimit);
            }
            if ((selector = spec.getSelector()) != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
                specBuilder.withSelector(matchLabels);
            }
            if ((template = spec.getTemplate()) != null) {
                specBuilder.withTemplate(template);
                PodSpec podSpec = template.getSpec();
                Objects.requireNonNull(podSpec, "No PodSpec for PodTemplate:" + template);
                List containers = podSpec.getContainers();
                Objects.requireNonNull(podSpec, "No containers for PodTemplate.spec: " + template);
            }
            DeploymentStrategy strategy = spec.getStrategy();
            String strategyType = null;
            if (strategy != null) {
                strategyType = strategy.getType();
            }
            if (this.openshiftDeployTimeoutSeconds != null && this.openshiftDeployTimeoutSeconds > 0L) {
                if (StringUtils.isBlank((CharSequence)strategyType) || "Rolling".equals(strategyType)) {
                    ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRollingParams()).endStrategy();
                } else if ("Recreate".equals(strategyType)) {
                    ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RecreateParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Recreate")).withNewRecreateParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRecreateParams()).endStrategy();
                } else {
                    ((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType(strategyType)).endStrategy();
                }
            } else if (StringUtils.isNotBlank((CharSequence)strategyType)) {
                ((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType(strategyType)).endStrategy();
            }
            if (this.enableAutomaticTrigger.booleanValue()) {
                ((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ConfigChange")).endTrigger();
            }
            specBuilder.endSpec();
        }
        return builder.build();
    }
}

