/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class RouteEnricher
extends BaseEnricher {
    public RouteEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-openshift-route");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        if (platformMode == PlatformMode.openshift) {
            final ArrayList routes = new ArrayList();
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    RouteEnricher.this.addRoute(listBuilder, serviceBuilder, routes);
                }
            });
            if (!routes.isEmpty()) {
                Route[] routeArray = new Route[routes.size()];
                routes.toArray(routeArray);
                listBuilder.addToRouteItems(routeArray);
            }
        }
    }

    private void addRoute(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder, List<Route> routes) {
        RoutePort routePort;
        String name;
        ObjectMeta metadata = serviceBuilder.getMetadata();
        if (metadata != null && this.isExposedService(serviceBuilder) && !this.hasRoute(listBuilder, name = metadata.getName()) && (routePort = this.createRoutePort(serviceBuilder)) != null) {
            routes.add(((RouteBuilder)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteBuilder)new RouteBuilder().withMetadata(serviceBuilder.getMetadata())).withNewSpec().withPort(routePort)).withNewTo().withKind("Service")).withName(name)).endTo()).endSpec()).build());
        }
    }

    private RoutePort createRoutePort(ServiceBuilder serviceBuilder) {
        IntOrString targetPort;
        ServicePort servicePort;
        List ports;
        RoutePort routePort = null;
        ServiceSpec spec = serviceBuilder.getSpec();
        if (spec != null && (ports = spec.getPorts()) != null && ports.size() > 0 && (servicePort = (ServicePort)ports.get(0)) != null && (targetPort = servicePort.getTargetPort()) != null) {
            routePort = new RoutePort();
            routePort.setTargetPort(targetPort);
        }
        return routePort;
    }

    private boolean hasRoute(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept((Visitor)new TypedVisitor<RouteBuilder>(){

            public void visit(RouteBuilder builder) {
                ObjectMeta metadata = builder.getMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        });
        return answer.get();
    }

    protected boolean isExposedService(ServiceBuilder serviceBuilder) {
        Service service = serviceBuilder.build();
        return this.isExposedService(service);
    }

    protected boolean isExposedService(Service service) {
        ObjectMeta metadata = service.getMetadata();
        if (metadata != null) {
            Map labels = metadata.getLabels();
            if (labels != null && ("true".equals(labels.get("expose")) || "true".equals(labels.get(Fabric8Annotations.SERVICE_EXPOSE_URL.value())))) {
                return true;
            }
        } else {
            this.log.info("No Metadata for service! " + service, new Object[0]);
        }
        return false;
    }
}

