/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceSpec;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectSpec;
import io.fabric8.openshift.api.model.ProjectStatus;
import io.fabric8.openshift.api.model.ProjectStatusBuilder;

public class ProjectEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "fmp-openshift-project";

    public ProjectEnricher(MavenEnricherContext context) {
        super((EnricherContext)context, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode == PlatformMode.openshift) {
            for (HasMetadata item : builder.buildItems()) {
                if (!(item instanceof Namespace)) continue;
                Project project = this.convertToProject((Namespace)item);
                KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)builder, (HasMetadata)item);
                builder.addToProjectItems(new Project[]{project});
            }
        }
    }

    private Project convertToProject(Namespace namespace) {
        ProjectBuilder builder = new ProjectBuilder();
        builder.withMetadata(namespace.getMetadata());
        if (namespace.getSpec() != null) {
            NamespaceSpec namespaceSpec = namespace.getSpec();
            ProjectSpec projectSpec = new ProjectSpec();
            if (namespaceSpec.getFinalizers() != null) {
                projectSpec.setFinalizers(namespaceSpec.getFinalizers());
            }
            builder.withSpec(projectSpec);
        }
        if (namespace.getStatus() != null) {
            ProjectStatus status = ((ProjectStatusBuilder)new ProjectStatusBuilder().withPhase(namespace.getStatus().getPhase())).build();
            builder.withStatus(status);
        }
        return builder.build();
    }
}

