/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImageChangeTriggerEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "fmp-openshift-imageChangeTrigger";
    private Boolean enableAutomaticTrigger = this.getValueFromConfig("fabric8.openshift.enableAutomaticTrigger", true);
    private Boolean enableImageChangeTrigger = this.getValueFromConfig("fabric8.openshift.imageChangeTriggers", true);
    private Boolean trimImageInContainerSpecFlag = this.getValueFromConfig("fabric8.openshift.trimImageInContainerSpec", false);

    public ImageChangeTriggerEnricher(MavenEnricherContext context) {
        super((EnricherContext)context, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode.equals((Object)PlatformMode.kubernetes)) {
            return;
        }
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigSpecBuilder>(){

            public void visit(DeploymentConfigSpecBuilder builder) {
                HashMap<String, String> containerToImageMap = new HashMap<String, String>();
                PodTemplateSpec template = builder.buildTemplate();
                if (template != null) {
                    PodSpec podSpec = template.getSpec();
                    Objects.requireNonNull(podSpec, "No PodSpec for PodTemplate:" + template);
                    List containers = podSpec.getContainers();
                    for (Container container : containers) {
                        if (container.getName() == null || container.getImage() == null) continue;
                        containerToImageMap.put(container.getName(), container.getImage());
                    }
                }
                if (containerToImageMap.size() != 0 && ImageChangeTriggerEnricher.this.enableImageChangeTrigger.booleanValue() && ImageChangeTriggerEnricher.this.isOpenShiftMode()) {
                    for (Map.Entry entry : containerToImageMap.entrySet()) {
                        String containerName = (String)entry.getKey();
                        if (!ImageChangeTriggerEnricher.this.isImageChangeTriggerNeeded(containerName).booleanValue()) continue;
                        ImageName image = new ImageName((String)entry.getValue());
                        String tag = image.getTag() != null ? image.getTag() : "latest";
                        ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)builder.addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(ImageChangeTriggerEnricher.this.enableAutomaticTrigger)).withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).withNamespace(image.getUser())).endFrom()).withContainerNames(new String[]{containerName})).endImageChangeParams()).endTrigger();
                    }
                    if (ImageChangeTriggerEnricher.this.trimImageInContainerSpecFlag.booleanValue()) {
                        ((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)builder.editTemplate().editSpec().withContainers(ImageChangeTriggerEnricher.this.trimImagesInContainers(template))).endSpec()).endTemplate();
                    }
                }
            }
        });
    }

    private Boolean isImageChangeTriggerNeeded(String containerName) {
        String containersFromConfig = Configs.asString((String)this.getConfig(Config.containers));
        Boolean enrichAll = this.getValueFromConfig("fabric8.openshift.enrichAllWithImageChangeTrigger", false);
        if (enrichAll.booleanValue()) {
            return true;
        }
        if (!(this.getProcessingInstructionViaKey("FABRIC8_GENERATED_CONTAINERS").contains(containerName) || this.getProcessingInstructionViaKey("IMAGECHANGE_TRIGGER").contains(containerName) || Arrays.asList(containersFromConfig.split(",")).contains(containerName))) {
            return false;
        }
        return true;
    }

    private List<Container> trimImagesInContainers(PodTemplateSpec template) {
        List containers = template.getSpec().getContainers();
        containers.forEach(container -> container.setImage(""));
        return containers;
    }

    private static enum Config implements Configs.Key
    {
        containers{
            {
                this.d = "";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

