/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;

public class WildFlySwarmHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public WildFlySwarmHealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-wildfly-swarm");
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.discoverWildFlySwarmHealthCheck(10);
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.discoverWildFlySwarmHealthCheck(180);
    }

    private Probe discoverWildFlySwarmHealthCheck(int initialDelay) {
        if (this.getContext().hasDependency("org.wildfly.swarm", "monitor") || this.getContext().hasDependency("org.wildfly.swarm", "microprofile-health")) {
            Integer port = this.getPort();
            String scheme = this.getScheme().toUpperCase();
            String path = this.getPath();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
        }
        return null;
    }

    protected String getScheme() {
        return Configs.asString((String)this.getConfig(Config.scheme));
    }

    protected int getPort() {
        return Configs.asInt((String)this.getConfig(Config.port));
    }

    protected String getPath() {
        return Configs.asString((String)this.getConfig(Config.path));
    }

    protected int getFailureThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.failureThreshold));
    }

    protected int getSuccessThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.successThreshold));
    }

    private static enum Config implements Configs.Key
    {
        scheme{
            {
                this.d = "HTTP";
            }
        }
        ,
        port{
            {
                this.d = "8080";
            }
        }
        ,
        failureThreshold{
            {
                this.d = "3";
            }
        }
        ,
        successThreshold{
            {
                this.d = "1";
            }
        }
        ,
        path{
            {
                this.d = "/health";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

