/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import com.google.common.base.Objects;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.maven.core.model.GroupArtifactVersion;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.docker.config.HealthCheckConfiguration;
import io.fabric8.maven.docker.config.HealthCheckMode;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.api.util.GoTimeUtil;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;
import java.util.Collections;
import java.util.List;

public class DockerHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public DockerHealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-docker");
    }

    @Override
    protected Probe getReadinessProbe(ContainerBuilder container) {
        return this.getProbe(container);
    }

    @Override
    protected Probe getLivenessProbe(ContainerBuilder container) {
        return this.getProbe(container);
    }

    private Probe getProbe(ContainerBuilder container) {
        ImageConfiguration image = this.getImageWithContainerName(container.getName());
        if (image != null) {
            return this.getProbe(image);
        }
        return null;
    }

    private Probe getProbe(ImageConfiguration image) {
        if (this.hasHealthCheck(image)) {
            HealthCheckConfiguration health = image.getBuildConfiguration().getHealthCheck();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(new ExecAction(health.getCmd().asStrings()))).withTimeoutSeconds(GoTimeUtil.durationSeconds((String)health.getTimeout()))).withPeriodSeconds(GoTimeUtil.durationSeconds((String)health.getInterval()))).withFailureThreshold(health.getRetries())).build();
        }
        return null;
    }

    private boolean hasHealthCheck(ImageConfiguration image) {
        return image.getBuildConfiguration() != null && image.getBuildConfiguration().getHealthCheck() != null && image.getBuildConfiguration().getHealthCheck().getCmd() != null && image.getBuildConfiguration().getHealthCheck().getMode() == HealthCheckMode.cmd;
    }

    private ImageConfiguration getImageWithContainerName(String containerName) {
        if (containerName == null) {
            return null;
        }
        List images = this.getImages().orElse(Collections.emptyList());
        for (ImageConfiguration image : images) {
            String imageContainerName = KubernetesResourceUtil.extractContainerName((GroupArtifactVersion)this.getContext().getGav(), (ImageConfiguration)image);
            if (!Objects.equal((Object)containerName, (Object)imageContainerName)) continue;
            return image;
        }
        return null;
    }
}

