/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractHealthCheckEnricher
extends BaseEnricher {
    public static String ENRICH_CONTAINERS = "fabric8.enricher.basic.enrichContainers";
    public static String ENRICH_ALL_CONTAINERS = "fabric8.enricher.basic.enrichAllContainers";

    public AbstractHealthCheckEnricher(EnricherContext buildContext, String name) {
        super(buildContext, name);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (this.checkIfHealthChecksDisabled(false).booleanValue()) {
            return;
        }
        for (ContainerBuilder container : this.getContainersToEnrich(builder)) {
            Probe probe;
            if (!container.hasReadinessProbe().booleanValue() && (probe = this.getReadinessProbe(container)) != null) {
                this.log.info("Adding readiness " + this.describe(probe), new Object[0]);
                container.withReadinessProbe(probe);
            }
            if (container.hasLivenessProbe().booleanValue() || (probe = this.getLivenessProbe(container)) == null) continue;
            this.log.info("Adding liveness " + this.describe(probe), new Object[0]);
            container.withLivenessProbe(probe);
        }
    }

    private String describe(Probe probe) {
        StringBuilder desc = new StringBuilder("probe");
        if (probe.getHttpGet() != null) {
            desc.append(" on port ");
            desc.append(probe.getHttpGet().getPort().getIntVal());
            desc.append(", path='");
            desc.append(probe.getHttpGet().getPath());
            desc.append("'");
            desc.append(", scheme='");
            desc.append(probe.getHttpGet().getScheme());
            desc.append("'");
        }
        if (probe.getInitialDelaySeconds() != null) {
            desc.append(", with initial delay ");
            desc.append(probe.getInitialDelaySeconds());
            desc.append(" seconds");
        }
        if (probe.getPeriodSeconds() != null) {
            desc.append(", with period ");
            desc.append(probe.getPeriodSeconds());
            desc.append(" seconds");
        }
        return desc.toString();
    }

    protected Boolean checkIfHealthChecksDisabled(Boolean defaultValue) {
        if (this.getContext().getProperty("fabric8.skipHealthCheck") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("fabric8.skipHealthCheck").toString());
        }
        return defaultValue;
    }

    protected List<ContainerBuilder> getContainersToEnrich(KubernetesListBuilder builder) {
        final LinkedList<ContainerBuilder> containerBuilders = new LinkedList<ContainerBuilder>();
        builder.accept((Visitor)new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder containerBuilder) {
                containerBuilders.add(containerBuilder);
            }
        });
        boolean enrichAllContainers = "true".equalsIgnoreCase(this.getConfig(Config.enrichAllContainers));
        String enrichContainers = this.getConfig(Config.enrichContainers);
        HashSet<String> containersToEnrich = new HashSet<String>();
        if (enrichContainers != null) {
            containersToEnrich.addAll(Arrays.asList(enrichContainers.split(",")));
        }
        if (enrichAllContainers) {
            return containerBuilders;
        }
        if (!containersToEnrich.isEmpty()) {
            LinkedList<ContainerBuilder> filteredContainers = new LinkedList<ContainerBuilder>();
            for (ContainerBuilder container : containerBuilders) {
                if (!container.hasName().booleanValue() || !containersToEnrich.contains(container.getName())) continue;
                filteredContainers.add(container);
            }
            return filteredContainers;
        }
        if (containerBuilders.size() == 1) {
            return containerBuilders;
        }
        LinkedList<ContainerBuilder> generatedContainers = new LinkedList<ContainerBuilder>();
        List fabric8GeneratedContainers = this.getProcessingInstructionViaKey("FABRIC8_GENERATED_CONTAINERS");
        for (ContainerBuilder container : containerBuilders) {
            if (!container.hasName().booleanValue() || !fabric8GeneratedContainers.contains(container.getName())) continue;
            generatedContainers.add(container);
        }
        return generatedContainers;
    }

    protected Probe getReadinessProbe(ContainerBuilder containerBuilder) {
        return this.getReadinessProbe();
    }

    protected Probe getReadinessProbe() {
        return null;
    }

    protected Probe getLivenessProbe(ContainerBuilder containerBuilder) {
        return this.getLivenessProbe();
    }

    protected Probe getLivenessProbe() {
        return null;
    }

    private static enum Config implements Configs.Key
    {
        enrichAllContainers{
            {
                this.d = "false";
            }
        }
        ,
        enrichContainers{
            {
                this.d = null;
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

